#!/usr/bin/python
# -*- coding: utf-8 -*-

#q-граммное расстояние между строками

Q = 2 #длина q-граммы

def qgr_dst(a, b):
    D = {}
    dst = 0

    k = Q - len(a)
    a += ' ' * k #дополнение коротких строк пробелами
    for i in range(len(a)-Q+1):
        #print "'" + a[i:i+Q] + "'"
        if D.has_key(a[i:i+Q]):
            D[a[i:i+Q]] += 1
        else:
            D[a[i:i+Q]] = 1
        dst += 1

    k = Q - len(b)
    b += ' ' * k
    for i in range(len(b)-Q+1):
        #print "'" + b[i:i+Q] + "'"
        if D.has_key(b[i:i+Q]):
            D[b[i:i+Q]] -= 1
            if D[b[i:i+Q]] >= 0:
                dst -= 1
            else:
                dst += 1
        else:
            D[b[i:i+Q]] = -1
            dst += 1

    #проверка вхождения одной строки в другую
    L = D.keys()
    #L.sort()
    plus = 0
    minus = 0
    for key in L:
        if D[key] > 0:
            plus += 1
        elif D[key] < 0:
            minus += 1
        #print key + ' ' + str(D[key])
    if plus * minus == 0:
        print "Одна из строк входит в другую"
    else:
        print "Строки друг в друга не входят"

    return dst


def main():
    a = 'Привет'
    b = 'привет'
    a = 'Типа Оптом и в розницу стальной круг'
    b = 'Оптом и в розницу стальная'

    a = unicode(a, 'utf-8')
    b = unicode(b, 'utf-8')

    print a
    print b

    dst = qgr_dst(a, b)
    print dst
    dst /= float(min(len(a), len(b)))
    print dst
    print 1 - dst
    #print '%.3f' % (1 - 2 * dst / (len(a) + len(b)))


if __name__ == '__main__':
    main()
