#!/usr/bin/perl -w
#дополнительное ранжирование эталонных баннеров на основе близости к семантическому ядру категории

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';

#use FindBin;
#use lib "$FindBin::Bin/../lib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({
    load_dicts   => 1,
    load_minicategs_light => 1, 
});


my $ctg_curr = "";
my %core; #лексическое ядро категории
my @ctg;
my %dup; #дубли баннеров
my $cnt = 0; #ProgressBar
while (<STDIN>) { #zzz
    chomp;

    my ($bid, $title, $body, $ctg, $num, $ent, $rank) = split /\t/;
    next if $num < 2; #min допустимое число фраз, использованных при категоризации

    print STDERR "$cnt\t$ctg\n" if ++$cnt % 1000 == 0; #ProgressBar

    my $bnr_pre = $proj->phrase("$title $body")->get_banner_prefiltered_phrase->text; #префильтрация баннера
    my $bnr_nrm = $proj->phrase($bnr_pre)->norm_phr; #нормализация текста баннера

    my @a = split / /, $bnr_nrm;

    if ($ctg_curr ne $ctg) {
        sem_core(\@ctg) if $ctg_curr ne ""; #вычисление семантического веса баннеров категории

        $ctg_curr = $ctg;
        %core = ();
        @ctg = ();
        %dup = ();
    }

    next if $dup{"$title\t$body"};
    $dup{"$title\t$body"} = 1;

    $core{$_}++ for @a; #частоты лемм
    my $a = join("\t", sort @a);
    push @ctg, "$_\t$a";
}

sem_core(\@ctg);


#--- вычисление семантического веса баннеров категории ---
sub sem_core {
    my ($ctg_bnrs) = @_; #баннеры, принадлежащие одной категории

    for my $bnr (@$ctg_bnrs) { #вычисление семантического веса баннеров категории
        my ($bid, $title, $body, $ctg, $num, $ent, $rank, @a) = split /\t/, $bnr;
        my $weight = 0;
        $weight += $core{$_} for @a;
        $weight /= @a; #усреднение
        $weight *= log2(@a+0); #учет числа значащих слов
        $weight = sprintf("%.2f", $weight);

        print "$bid\t$title\t$body\t$ctg\t$num\t$ent\t$rank\t$weight\t", @$ctg_bnrs+0, "\t", @a+0, "\n"; #@$ctg+0 - число баннеров в категории, @a - число значащих слов в баннере
    }
}


#--- двоичный логарифм ---
sub log2 {
    my $n = shift;
    return log($n)/log(2);
}
