#!/usr/bin/perl -w
#вычисление относительного ранга баннеров в эталонной выборке

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';


my $ctg_id_curr = "";
my $rank_max;
my $cnt = 0;
while (<STDIN>) { #bnr_text_rank_s
    chomp;

    my ($bid, $title, $body, $ctg_id, $rank) = split /\t/;
    print STDERR "$cnt\t$ctg_id\n" if ++$cnt % 10000 == 0; #ProgressBar

    if ($ctg_id_curr ne $ctg_id) {
        $ctg_id_curr = $ctg_id;
        $rank_max = $rank;
    }

    my $rank_rel = sprintf("%.3f", $rank / $rank_max);
    print "$_\t$rank_rel\n";
}
