#!/usr/bin/python
# -*- coding: utf-8 -*-

#поиск и печать категории в таблице эталонов

import sys
import re
import math

import yt.wrapper as yt


#--- progress bar ---
def progress(count, total, status=''):
    bar_len = 60
    filled_len = int(round(bar_len * count / float(total)))

    percents = round(100.0 * count / float(total), 1)
    bar = '■' * filled_len + '-' * (bar_len - filled_len)

    sys.stderr.write('[%s] %s%s ...%s\r' % (bar, percents, '%', status))
    sys.stderr.flush()


#--- поиск начала категории в таблице ---
def ctg_search(table, ctg_size, mctgs):
    input = table #исходная таблица
    row_count = yt.row_count(input)
    size = int(ctg_size)

    low = 0
    hi = row_count - 1
    steps = int(math.ceil(math.log(row_count, 2))) + 1 #число итераций в бинарном поиске
    step = 0;
    while low <= hi: #бинарный поиск урла в таблице
        mid = int((low + hi) / 2)
        input_range = input + '[#' + str(mid) + ':#' + str(mid+1) + ']' #прямой доступ к одной записи
        rec = next(yt.read_table(input_range, raw=False)) #итератор

        step += 1
        #------------------------------------------------
        progress(step, steps, status = 'Поиск в таблице')
        #------------------------------------------------

        if size < rec['size']:
            hi = mid - 1
        elif size > rec['size']:
            low = mid + 1
        elif mctgs < rec['mctgs']: #size == rec['size'], сравнение по второму полю
            hi = mid - 1
        elif mctgs > rec['mctgs']:
            low = mid + 1
        else: #совпадение
            if low < hi: #продолжение поиска для выбора ПЕРВОЙ записи ИЗ ГРУППЫ одинаковых
                hi = mid
            else:
                mid = hi #индекс ПЕРВОЙ записи в найденной ГРУППЕ записей с одинаковым доменом
                low = hi + 2 #ВЫХОД

    if low > row_count - 1:
        low = row_count - 1
    if hi < 0:
        hi = 0

    print >>sys.stderr
    if low == hi + 2: #поиск успешный
        input_range = input + '[#' + str(mid) + ':#' + str(mid+1) + ']' #прямой доступ к одной записи
        rec = next(yt.read_table(input_range, raw=False)) #итератор
        print >>sys.stderr, 'Нашли!: ' + str(mid) + '\t' + rec['title']

        return mid #индекс найденной записи в таблице
    else:
        print >>sys.stderr, 'Поиск неудачный :('
        return -1


#--- печать баннеров категории ---
def ctg_print(input, ind, first, total):
    input_range = input + '[#' + str(ind) + ':]' #диапазон для просмотра таблицы от найденного места до конца
    bnr_num = 0
    bnr_cnt = 0

    for rec in yt.read_table(input_range, raw=False):
        bnr_num += 1
        if bnr_num < int(first):
            continue
        print str(rec['bid']) + '\t' + rec['title'] + '\t' + str(rec['rank_rel'])
        bnr_cnt += 1
        if bnr_cnt >= int(total):
            break


def main():
    input = '//home/catalogia/users/yuryz/bnrs_rank_rel' #исходная таблица

    ind = ctg_search(input, sys.argv[1], sys.argv[2]) #поиск начала категории в таблице (sys.argv[1] - число баннеров в категории, sys.argv[2] - категория)
    if ind < 0:
        return 1 #поиск неудачный

    ctg_print(input, ind, sys.argv[3], sys.argv[4]) #sys.argv[3] - номер первого баннера для печати, sys.argv[4] - число баннеров для печати

if __name__ == '__main__':
    main()
