#!/usr/bin/perl -w
#выбор баннеров для эталонной выборки

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my %ctg2id;
open F, "ctg2id";
while (<F>) {
    chomp;
    my @a = split /\t/; #0 - CTG, 1 - ID
    $ctg2id{$a[0]} = $a[1];
}

my $MIN = 50; #MIN значение моды

my %camp2ctg;

open F, "camp_stat_s";
while (<F>) {
    chomp;
    my @a = split /\t/; #0 - CAMP, 3 - MOD1, 4 - CTG1, 5 - MOD2, 6 - CTG2
    if ($a[3] >= $MIN && $a[5] && $a[3] / $a[5] >= 2) { #критерий ЭТАЛОНА
        $camp2ctg{"$a[0]\t$a[4]"} = 1;
    }
}

open F, "camp_stat_log"; #кампании, состоящие только из одной категории
while (<F>) {
    chomp;
    my @a = split /\t/; #0 - CAMP, 1 - SIZ, 2 - CTG_NUM
    if ($a[1] && $a[1] >= $MIN && $a[2] && $a[2] == 1) { #критерий ЭТАЛОНА
        $camp2ctg{$a[0]} = 1; #выбираем все записи кампании $a[0], т.к. они принадлежат ЕДИНСТВЕННОЙ категории
    }
}

my $cnt = 0;
my $t1 = localtime;

while (<STDIN>) { #zcat /opt/broadmatching/work/direct_client/banners_extended.gz
    chomp;
    my @a = split /\t/; #0 - ID, 1 - CAMPAIGN_ID, 3 - TITLE, 4 - BODY, 20 - CATEGS (mctgs=Защита автомобиля от внешних воздействий/Кабельные каналы, короба, перфорированные короба)

    my $ctgs = substr($a[20], 6);
    my @ctgs = split m{/}, $ctgs; #омонимичный баннер

    my $ctg_id;
    my @ctg_id;

    if (@ctgs) {
        for my $ctg (@ctgs) {
            push @ctg_id, $ctg2id{$ctg} ? $ctg2id{$ctg} : $ctg;
        }
        $ctg_id = join("/", @ctg_id);

        if ($camp2ctg{"$a[1]\t$ctg_id"} || $camp2ctg{$a[1]}) { #ЭТАЛОН
            print "$a[0]\t$a[3]\t$a[4]\t$ctgs\n"; #без CAMPAIGN_ID
        }
    }
}

my $t2 = localtime;
print STDERR scalar($t1), "\n";
print STDERR scalar($t2), "\n";
