#!/usr/bin/perl -w
#выбор фраз из виртуальных категорий Каталогии

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


open F, "4stat_2_s";
while (<F>) {
    chomp;

    my ($pref, $ctg, $freq) = split /\t/; #префикс, категория, частота

    my @ctg_phrs = $proj->default_language->get_category_raw_phrases($ctg);
    @ctg_phrs = sort {lc($a) cmp lc($b)} @ctg_phrs; #сортировка без учета регистра

    if (@ctg_phrs) {
        my $phr_num = 0; #порядковый номер фразы внутри категории
        for my $ctg_phr (@ctg_phrs) {
            $phr_num++;
            print "$ctg\t$ctg_phr\t$phr_num\n";
        }
    }
}
