#!/usr/bin/perl -w
#получение основных статистических характеристик для распределения категорий внутри кампаний

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");


my %freq; #частотный словарь категорий внутри кампаний
my $t1 = localtime;
while (<STDIN>) { #bnrs_200kk_uniq
    chomp;
    my ($camp_id, $ctg_id, $bnr_id) = split /\t/;

    $freq{$camp_id}{$ctg_id}++;
}

my $t2 = localtime;
print STDERR scalar($t1), "\n";
print STDERR scalar($t2), "\n";

print STDERR scalar keys %freq, "\n";

for my $camp_id (sort keys %freq) {
    my $siz = 0; #размер выборки
    my $mod1 = 0; #мода 1
    my $ctg_id1 = ""; #категория для моды 1
    my $mod2 = 0; #мода 2
    my $ctg_id2 = ""; #категория для моды 2
    for my $ctg_id (keys %{$freq{$camp_id}}) {
        $siz += ${$freq{$camp_id}}{$ctg_id};
        #$mod = ${$freq{$camp_id}}{$ctg_id} if $mod < ${$freq{$camp_id}}{$ctg_id};
        if ($mod1 < ${$freq{$camp_id}}{$ctg_id}) {
            $mod2 = $mod1;
            $ctg_id2 = $ctg_id1;
            $mod1 = ${$freq{$camp_id}}{$ctg_id};
            $ctg_id1 = $ctg_id;
        } elsif ($mod2 < ${$freq{$camp_id}}{$ctg_id}) {
            $mod2 = ${$freq{$camp_id}}{$ctg_id};
            $ctg_id2 = $ctg_id;
        }
    }
    
    my $ctg_num = scalar keys %{$freq{$camp_id}}; #число уникальных категорий
    next if $siz == $ctg_num; #заведомо плохое распределение (число баннеров равно числу категорий)

    my $avg = sprintf("%.2f", $siz / $ctg_num); #среднее распределения

    my $var = 0; #дисперсия
    my $exc = 0; #эксцесс
    for my $ctg_id (keys %{$freq{$camp_id}}) {
        $var += ( ${$freq{$camp_id}}{$ctg_id} - $avg ) ** 2;
        $exc += ( ${$freq{$camp_id}}{$ctg_id} - $avg ) ** 4;
    }
    if ($var == 0) {
        print STDERR "$camp_id\t$siz\t$ctg_num\n";
        next;
    }

    $var /= $siz;
    $exc /= $siz;
    $exc = $exc / $var ** 2 - 3;

    $var = sprintf("%.2f", $var);
    $exc = sprintf("%.2f", $exc);

    my $rank = 0;
    $rank = sprintf("%.2f", log($siz) * log($mod1) * log($exc) / log($ctg_num)) if $exc > 0;

    #print "$camp_id\t$siz\t$ctg_num\t$avg\t$mod1\t$var\t$exc\t$rank\n";
    print "$camp_id\t$siz\t$ctg_num\t$mod1\t$ctg_id1\t$mod2\t$ctg_id2\t$exc\t$rank\n";
}
