#!/usr/bin/perl -w
#проверка категориации с помощью голосования

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDOUT, ':utf8';

use FindBin;
use lib "$FindBin::Bin/../lib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({
    load_dicts   => 1,
    load_minicategs_light => 1, 
});

my $ID = "666781891"; #проверяемый баннер

while (<STDIN>) { #<bnrs_200kk_samp_u (или zpattern_1a)
    chomp;
    my ($bnr_id, $title, $body, $ctgs) = split /\t/;
    my $ctgs_src = join("/", sort split(m{/}, $ctgs));

    next if $bnr_id ne $ID;

    my $bnr = $proj->bf->get_banner_by_id($bnr_id);
    next unless $bnr;

    my %ctgs; #частотный словарь категорий

    my @ctgs = $bnr->get_minicategs;
    next if @ctgs == 0;
    next if @ctgs > 1; #####

    my $phrs = $bnr->get_categs_phrases_hlist; #фразы, по которым происходила категоризация (массив хешей - ссылка)
    for my $phr (@$phrs) {
        print "$$phr{'category'}\n";
        print "'$$phr{'phrase'}'\n";
    }

    my $ctgs_curr = join("/", sort @ctgs);
    $ctgs{$ctgs_curr}++;

    my $h = $bnr->get_intent; #ссылка на хеш с ключом intent
    my $phr = $proj->phrase($$h{intent});
    if ($phr) {
        @ctgs = $phr->get_minicategs; #категоризация по intent
        $ctgs{join("/", sort @ctgs)}++ if @ctgs;

        @ctgs = $phr->get_minicategs_snippets; #категоризация по intent
        $ctgs{join("/", sort@ctgs)}++ if @ctgs;
    }

    my ($brand, $model) = $bnr->parse; #массив: (brand, model)
    my $br_mod;
    if ($brand && $model) {
        $br_mod = "$brand $model";
    } elsif ($brand) {
        $br_mod = $brand;
    } elsif ($model) {
        $br_mod = $model;
    } else {
        $br_mod = "";
    }
    $phr = $proj->phrase($br_mod);
    if ($phr) {
        @ctgs = $phr->get_minicategs_snippets; #категоризация по brand+model
        $ctgs{join("/", sort @ctgs)}++ if @ctgs;
    }

    @ctgs = sort { $ctgs{$b} <=> $ctgs{$a} || $a cmp $b} keys %ctgs; #по убыванию результатов голосования
    if (@ctgs && (@ctgs == 1 && $ctgs{$ctgs[0]} > 1 || @ctgs > 1 && $ctgs{$ctgs[0]} > $ctgs{$ctgs[1]})) {
        print "$bnr_id\t$title\t$body\t$ctgs[0]\t'$ctgs'";
        print "\t$ctgs[1]" if $ctgs[1];
    }
    print "\n";

    for (sort { $ctgs{$b} <=> $ctgs{$a} || $a cmp $b} keys %ctgs) {
        print "\t$_\t$ctgs{$_}\n";
    }
    last if $bnr_id eq $ID;
}
