#!/usr/bin/perl -w
#проверка категориации с помощью голосования

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDOUT, ':utf8';

use FindBin;
use lib "$FindBin::Bin/../lib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({
    load_dicts   => 1,
    load_minicategs_light => 1, 
});

my $ID = "73690929"; #проверяемый баннер

my $bnr = $proj->bf->get_banner_by_id($ID);
next unless $bnr;

my %ctgs; #частотный словарь категорий

my @ctgs = $bnr->get_minicategs;
next if @ctgs == 0;
next if @ctgs > 1; #####

my $phrs = $bnr->get_categs_phrases_hlist; #фразы, по которым происходила категоризация (массив хешей - ссылка)
my %wrds;
for my $phr (@$phrs) {
    my @wrds = split / /, $$phr{'phrase'}; #число слов, по которым выполнялась категоризация
    $wrds{$$phr{'category'}} += @wrds;
    print "1.\t$$phr{'category'}:\t$$phr{'phrase'}\n";
}

my $ctgs_curr = join("/", sort @ctgs);
$ctgs{$ctgs_curr}++;

my $h = $bnr->get_intent; #ссылка на хеш с ключом intent
my $phr = $proj->phrase($$h{intent});
if ($phr) {
    @ctgs = $phr->get_minicategs; #категоризация по intent

    #--------------------
    my $phrs = $phr->get_categs_phrases_hlist; #фразы, по которым происходила категоризация (массив хешей - ссылка)
    for my $phr (@$phrs) {
        my @wrds = split / /, $$phr{'phrase'}; #число слов, по которым выполнялась категоризация
        $wrds{$$phr{'category'}} += @wrds;
        print "2.\t$$phr{'category'}:\t$$phr{'phrase'}\n";
    }
    #--------------------

    $ctgs{join("/", sort @ctgs)}++ if @ctgs;

    @ctgs = $phr->get_minicategs_snippets; #категоризация по intent
    $ctgs{join("/", sort@ctgs)}++ if @ctgs;
}

my ($brand, $model) = $bnr->parse; #массив: (brand, model)
my $br_mod;
if ($brand && $model) {
    $br_mod = "$brand $model";
} elsif ($brand) {
    $br_mod = $brand;
} elsif ($model) {
    $br_mod = $model;
} else {
    $br_mod = "";
}
$phr = $proj->phrase($br_mod);
if ($phr) {
    @ctgs = $phr->get_minicategs_snippets; #категоризация по brand+model
    $ctgs{join("/", sort @ctgs)}++ if @ctgs;
}

my @bnr_categs = $bnr->get_categs_neighbors;
print "<@bnr_categs>\n";

@ctgs = sort { $ctgs{$b} <=> $ctgs{$a} || $a cmp $b} keys %ctgs; #по убыванию результатов голосования
if (@ctgs == 1 && $ctgs{$ctgs[0]} > 1) { #в хеше ровно ОДНА категория и число голосов за нее > 1
    print "$ID\t", $bnr->banner_text_phrase->text,  "\t$ctgs[0]\t$ctgs{$ctgs[0]}\t$wrds{$ctgs[0]}\n";
    #print "***** ", $bnr->banner_text_phrase->text, "\n";
}

#for (sort { $ctgs{$b} <=> $ctgs{$a} || $a cmp $b} keys %ctgs) {
#    print "\t$_\t$ctgs{$_}\n";
#}
