#!/usr/bin/perl -w
#проверка категориации с помощью голосования

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDOUT, ':utf8';

use FindBin;
use lib "$FindBin::Bin/../lib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";

use Utils::Common;
use Project;

my $proj = Project->new({
    load_dicts   => 1,
    load_minicategs_light => 1, 
});

my $worker = Utils::Worker->new;
$worker->{verbose}    = 1;
$worker->{num_processes}    = 12;

#$worker->{file_input}       = "/home/yuryz/scripts/sample/bnrs_200kk_samp_u";
$worker->{file_input}       = "/home/yuryz/scripts/sample/zpattern_1";
$worker->{file_output}      = "/home/yuryz/scripts/sample/bnrs_200kk_samp_lst2";

$worker->{process_line}     = sub {
    my ($line, $fh) = @_;
    chomp $line;

    my ($bnr_id, $title, $body, $ctgs) = split /\t/, $line;
    my $ctgs_src = join("/", sort split(m{/}, $ctgs));

    my $bnr = $proj->bf->get_banner_by_id($bnr_id);
    return unless $bnr;

    my %ctgs; #частотный словарь категорий

    my @ctgs = $bnr->get_minicategs;
    return if @ctgs == 0;
    return if @ctgs > 1; #####

    my $phrs = $bnr->get_categs_phrases_hlist; #фразы, по которым происходила категоризация (массив хешей - ссылка)
    my $wrd_cnt = 0;
    for my $phr (@$phrs) { #каждый хеш содержит 2 ключа: $$phr{'category'} и $$phr{'phrase'}
        my @wrds = split / /, $$phr{'phrase'}; #число слов, по которым выполнялась категоризация
        return if @wrds < 2; #####
        $wrd_cnt = @wrds+0;
    }

    my $ctgs_curr = join("/", sort @ctgs);
    return if $ctgs_curr ne $ctgs_src; #####
    $ctgs{$ctgs_curr}++; #*** 1-Й ГОЛОС ***

    my $h = $bnr->get_intent; #ссылка на хеш с ключом intent
    my $phr = $proj->phrase($$h{intent});
    if ($phr) {
        @ctgs = $phr->get_minicategs; #категоризация по intent
        $ctgs{join("/", sort @ctgs)}++ if @ctgs; #*** "2-Й ГОЛОС ***

        @ctgs = $phr->get_minicategs_snippets; #категоризация по intent
        $ctgs{join("/", sort @ctgs)}++ if @ctgs; #*** 3-Й ГОЛОС ***
    }

    my ($brand, $model) = $bnr->parse; #массив: (brand, model)
    my $br_mod;
    if ($brand && $model) {
        $br_mod = "$brand $model";
    } elsif ($brand) {
        $br_mod = $brand;
    } elsif ($model) {
        $br_mod = $model;
    } else {
        $br_mod = "";
    }
    $phr = $proj->phrase($br_mod);
    if ($phr) {
        @ctgs = $phr->get_minicategs_snippets; #категоризация по brand+model
        $ctgs{join("/", sort @ctgs)}++ if @ctgs; #*** 4-Й ГОЛОС ***
    }

    @ctgs = sort { $ctgs{$b} <=> $ctgs{$a} || $a cmp $b} keys %ctgs; #по убыванию результатов голосования
    if (@ctgs == 1 && $ctgs{$ctgs[0]} > 1) { #в хеше ровно ОДНА категория и число голосов за нее > 1
        my $rank = $ctgs{$ctgs[0]} * $wrd_cnt;
        print $fh "$bnr_id\t$title\t$body\t$ctgs[0]\t$ctgs{$ctgs[0]}\t$wrd_cnt\t$rank\n";
    }
};

$worker->process_data;

