#!/usr/bin/perl -w
#упрощенный алгоритм формирования эталонной выборки

use strict;

use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDOUT, ':utf8';

use FindBin;
use lib "$FindBin::Bin/../lib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";

use Utils::Common;
use Project;

my $proj = Project->new({
    load_dicts   => 1,
    load_minicategs_light => 1, 
});

my $worker = Utils::Worker->new;
$worker->{verbose}    = 1;
$worker->{num_processes}    = 20;

$worker->{file_input}       = "/home/yuryz/scripts/sample/bnrs_200kk_uniq_sb";
$worker->{file_output}      = "/home/yuryz/scripts/sample/bnrs_200kk_samp_lst4b";

$worker->{process_line}     = sub {
    my ($line, $fh) = @_;
    chomp $line;

    my ($cmp_id, $ctg_id, $bnr_id) = split /\t/, $line;

    my $bnr = $proj->bf->get_banner_by_id($bnr_id);
    return unless $bnr;

    my @ctgs = $bnr->get_minicategs;
    return if @ctgs == 0;
    return if @ctgs > 1; #####

    my $phrs = $bnr->get_categs_phrases_hlist; #фразы, по которым происходила категоризация (массив хешей - ссылка)
    return if @$phrs < 2;

    my %ctgs; #общее число слов в каждой категории, по которым выполнялась категоризация
    my %ent; #данные для энтропии

    for my $phr (@$phrs) { #каждый хеш содержит 2 ключа: $$phr{'category'} и $$phr{'phrase'}
        my @wrds = split / /, $$phr{'phrase'}; #число слов, по которым выполнялась категоризация
        $ent{$_}++ for @wrds;
        $ctgs{$$phr{'category'}} += @wrds;
    }

    my $keys_cnt = scalar keys %ctgs;
    my $ctg_unq = (keys %ctgs)[0]; #ПОКА - единственная категория (return if @ctgs > 1;), омонимы - ПОТОМ

    my $ent = 0; #энтропия
    for (sort keys %ent) {
        my $tmp = $ent{$_} / $ctgs{$ctg_unq};
        $ent -= $tmp * log2($tmp);
    }
    $ent = sprintf("%.3f", $ent);

    my $rank = @$phrs * $ent; #ранжирование эталонов

    #if ($keys_cnt == 1 && $ctgs{$ctg_unq} >= 2) { #в хеше ровно ОДНА категория и суммарное число слов во фразах >= 2
    if ($keys_cnt == 1 && @$phrs >= 2) { #в хеше ровно ОДНА категория и число фраз, по которым происходила категоризация >= 2
        my $title = $bnr->title;
        my $body = $bnr->body;
        #print $fh "$bnr_id\t$title\t$body\t$ctg_unq\t$ctgs{$ctg_unq}\t", @$phrs+0, "\n";
        print $fh "$bnr_id\t$title\t$body\t$ctg_unq\t", @$phrs+0, "\t$ent\t$rank\n";
    }
};

$worker->process_data;


#--- двоичный логарифм ---
sub log2 {
    my $n = shift;
    return log($n)/log(2);
}
