#!/usr/bin/python
# -*- coding: utf-8 -*-

#выбор эталонных баннеров для тестирования

import yt.wrapper as yt
import sys


#--- progress bar ---
def progress(count, total, status=''):
    bar_len = 50
    filled_len = int(round(bar_len * count / float(total)))

    percents = round(100.0 * count / float(total), 1)
    bar = '■' * filled_len + '-' * (bar_len - filled_len)

    sys.stderr.write('[%s] %s%s ...%s\r' % (bar, percents, '%', status))
    sys.stderr.flush()


def main():
    input = '//home/catalogia/users/yuryz/bnrs_rank_rel_s'
    total = yt.row_count(input)

    BNRS_MAX = 2 #максимальное число баннеров, выбираемых из каждой категории
    RANK_MAX = 1 #максимальный ранг, начиная с которого выбираются баннеры

    mctgs_prev = ''

    bar_cnt = 0
    for rec in yt.read_table(input, raw=False):
        bar_cnt += 1
        if bar_cnt % 10000 == 0:
            progress(bar_cnt, total, status = 'Выбор эталонных баннеров')

        if mctgs_prev == '' or mctgs_prev != rec['mctgs']:
            mctgs_prev = rec['mctgs']
            bnr_cnt = 0

        bnr_cnt += 1
        if bnr_cnt <= BNRS_MAX:
            if -rec['rank_rel'] <= RANK_MAX:
                print rec['mctgs'] + '\t' + str(rec['bid']) + '\t' + rec['title'] + '\t' + rec['body']+ '\t' + str(-rec['rank_rel']) + '\t' + str(-rec['size'])

    print >>sys.stderr


if __name__ == '__main__':
    main()
