#!/usr/bin/python
# -*- coding: utf-8 -*-

#первичный выбор баннеров и удаление дублей

import sys
import yt.wrapper as yt


def bnrs_select(rec): #первичный выбор баннеров с категориями
    if rec['mctgs'] and rec['mctgs'] != '' and rec['mctgs'].find('/') == -1: #омонимичные баннеры не обрабатываем
        if rec['title'] and rec['title'] != '' and rec['body'] and rec['body'] != '':
            yield { "bid": rec['bid'], "title": rec['title'], "body": rec['body'], "mctgs": rec['mctgs'] }


def del_dup(key, recs): #удаление дублей
    yield recs.next()


def main():
    with yt.TempTable() as bnrs_raw:
        yt.run_map(bnrs_select, sys.argv[1], bnrs_raw)
        yt.run_sort(bnrs_raw, sort_by=['title', 'body', 'bid'])

        yt.run_reduce(del_dup, bnrs_raw, sys.argv[2], reduce_by=['title', 'body'])
        yt.run_sort(sys.argv[2], sort_by=['bid'])


if __name__ == '__main__':
    main()
