#!/usr/bin/python
# -*- coding: utf-8 -*-

#     

import math
import yt.wrapper as yt


def reducer(key, recs):
    count = 0
    for rec in recs:
        count += 1
    yield { "rank_rel": key['rank_rel'], "count": count }


def main():
    input = '//home/catalogia/users/yuryz/bnrs_etalon'
    output = '//home/catalogia/users/yuryz/bnrs_count'

    yt.run_reduce(reducer, [input], [output], reduce_by = ['rank_rel'])
    yt.run_sort(output, sort_by=['rank_rel'])

    print yt.row_count(input)
    print yt.row_count(output)


if __name__ == '__main__':
    main()
