#! /usr/bin/env perl

use lib 'scripts/lib';

use utf8;
use Project;

my $proj = Project->new({
    load_dicts                              => 1,
    load_minicategs_light                   => 1,
    allow_lazy_dicts                        => 1,
    use_comptrie_subphraser                 => 1,
    use_sandbox_categories_suppression_dict => 1,
});
$proj->categs_tree->never_read_categs_cache(1);
$proj->categs_tree->never_write_categs_cache(1);

while (my $line = <STDIN>) {
    chomp($line);
    my $banner = $proj->bf->text2banner($line);
    my @categories = $banner->get_minicategs();
    print join("\t",
        $banner->id,
        $banner->title,
        $banner->body,
        join('/', @categories),
    ), "\n" if @categories == 1;
}
