#! /usr/bin/env perl

use lib 'scripts/lib';

use utf8;
use Project;

my $proj = Project->new({
    load_dicts                              => 1,
    load_minicategs_light                   => 1,
    allow_lazy_dicts                        => 1,
    use_comptrie_subphraser                 => 1,
    use_sandbox_categories_suppression_dict => 1,
});
$proj->categs_tree->never_read_categs_cache(1);
$proj->categs_tree->never_write_categs_cache(1);

while (my $line = <STDIN>) {
    chomp($line);
    my @a = split /\t/, $line;
    my $title;
    my $body;
    for my $a (@a) {
        $title = substr($a, 6) if $a =~ /^title=/;
        $body = substr($a, 5) if $a =~ /^body=/;
    }
    my $bnr_pre = $proj->phrase("$title $body")->get_banner_prefiltered_phrase->text; # 
    my $bnr_nrm = $proj->phrase($bnr_pre)->norm_phr; #  

    print "$line\tbnorm=$bnr_nrm\n";
}
