#!/usr/bin/python
# -*- coding: utf-8 -*-

#выбор баннеров для проверки качества категоризации

import random
import yt.wrapper as yt


def bnrs_select(key, recs): #случайный выбор баннера
    mctgs = ''
    num = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            mctgs = rec['mctgs']
        else:
            if mctgs != '':
                num += 1
                if random.uniform(0, num) < 1:
                    row = rec
    if mctgs != '':
        yield row


def main():
    tab1 = '//tmp/yuryz/ctgs_full_100'
    tab2 = '//home/catalogia/users/yuryz/bnrs_rank_rel_s'
    tab3 = '//tmp/yuryz/bnrs4test'

    #yt.run_reduce(bnrs_select, [tab1, tab2], tab3, reduce_by=['mctgs'])
    #yt.run_sort(tab3, sort_by=['bid'])

    #print yt.row_count(tab1)
    #print yt.row_count(tab2)
    #print yt.row_count(tab3)

    L = []
    for rec in yt.read_table(tab3, raw=False):
        L.append(rec)
    random.shuffle(L)

    TEST_SIZE = 1000
    print 'bid\ttitle\tbody\touter_category' #заголовки столбцов таблицы
    for i in range(TEST_SIZE):
        print str(L[i]['bid']) + '\t' + L[i]['title'] + '\t' + L[i]['body'] + '\t' + L[i]['mctgs']


if __name__ == '__main__':
    main()
