#!/usr/bin/perl -w
use strict;

use utf8;
use open ':utf8';

#use FindBin;
#use lib "$FindBin::Bin/../lib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";

use Project;

use Utils::Common;
use Utils::Sys;

Utils::Sys::get_file_lock() or exit(0);
Utils::Sys::handle_errors();

my $proj = Project->new({});

my $tries = 5;
my $sleep_between_tries = 120;

my $yt_client = $proj->yt_client->set_params(
    pool                => 'catalogia',
    tries               => $tries,
    sleep_between_tries => $sleep_between_tries,
);

my $src_table = $ARGV[0]; #//tmp/yuryz/bnrs_uniq
my $dst_table = $ARGV[1]; #//home/catalogia/users/yuryz/bnrs_norm

my $bytes_per_gigabyte = 1 << 30;
my $tmpfs_size = 8 * $bytes_per_gigabyte;
my $memory_limit = 8 * $bytes_per_gigabyte;
my $data_size_per_job = 100*(1<<20);

$yt_client->do_project_cmd(
    'map',
    "'./mr_perl ./bnrs_norm_map.pl'",
    "--local-file=./bnrs_norm_map.pl",
    "--src=$src_table",
    "--dst=$dst_table",
    "'--input-format=dsv'",
    "'--output-format=dsv'",
    qq/'--spec={"mapper"={"tmpfs_path"="."; "copy_files"=true; "tmpfs_size"=$tmpfs_size; "memory_limit"=$memory_limit;};"data_size_per_job"=$data_size_per_job;}'/,
);

Utils::Sys::release_file_lock();
