#!/usr/bin/python
# -*- coding: utf-8 -*-

#добавление размера кластеров к ядрам Каталогии для баннеров с dist (//home/catalogia/users/yuryz/ctg_corr/core_title_dist)

import sys
import re
import math

import yt.wrapper as yt


def add_clast_size(key, recs): #добавление размера кластера к каждому ядру
    clast_size = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            clast_size = rec['clast_size']
        else:
            if clast_size != 0:
                rec['clast_size'] = clast_size
                yield rec


def main():
    tab1 = '//home/catalogia/users/yuryz/ctg_corr/core_title_dist'
    tab2 = '//tmp/yuryz/core_title_dist'

    yt.run_sort(tab1, tab2, sort_by=['clast_phrase', 'mctgs'])

    tab3 = '//home/catalogia/users/yuryz/tmp/clast_by_phrase'
    tab4 = '//home/catalogia/users/yuryz/ctg_corr/core_title_dist_size'

    yt.run_reduce(add_clast_size, [tab3, tab2], tab4, reduce_by = ['clast_phrase', 'mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab4, sort_by=['mctgs', 'clast_size', 'clast_phrase', 'dist', 'bid'])


if __name__ == '__main__':
    main()
