#!/usr/bin/python
# -*- coding: utf-8 -*-

#добавление размера кластеров к ядрам Каталогии для баннеров с dist (//home/catalogia/users/yuryz/ctg_corr/core_title_dist)

import sys
import re
import math

import yt.wrapper as yt


def add_href_cid(key, recs): #добавление размера кластера к каждому ядру
    href = ''
    cid = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            href = rec['href']
            cid = rec['cid']
        else:
            rec['href'] = href
            rec['cid'] = cid
            yield { "bid": int(rec['bid']), "title": rec['title'], "body": rec['body'], "mctgs": rec['mctgs'], "href": rec['href'], "cid": int(rec['cid']) }


def main():
    tab1 = '//home/catalogia/users/yuryz/ctg_corr/core_title_dist_size'
    tab2 = '//tmp/yuryz/core_title_dist_size'

    #yt.run_sort(tab1, tab2, sort_by=['bid'])

    tab3 = '//home/catalogia/banners_extended'
    tab4 = '//tmp/yuryz/core_title_href_cid' #url + кампания

    yt.run_reduce(add_href_cid, [tab3, tab2], tab4, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab4, sort_by=['mctgs', 'clast_size', 'clast_phrase', 'dist', 'bid'])


if __name__ == '__main__':
    main()
