#!/usr/bin/perl -w
#выбор категорий по аналогии с уже проверенными 2000

use strict;
use utf8;
use open ':utf8';
use URI;

no warnings 'utf8';

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my %url2ctg; #обучающая выборка
open F, "no_categ_corr_3000";
while (<F>) { #формирование обучающей выборки
    chomp;
    my ($_yql_column_0, $bid, $title, $body, $ctg, $href) = split /\t/;

    my $url = URI->new($href);
    next unless $url;
    my $path = $url->path();
    $path =~ s{/$}{};

    my $sign = $url->host().$path; #сигнатура
    if ($url2ctg{$sign}) { #случай нескольких категорий
        unless ($url2ctg{$sign} =~ /$ctg/) { #одинаковые категории (ДУБЛИ) - исключаем
            $url2ctg{$sign} .= "/$ctg";
        }
    } else {
        $url2ctg{$sign} = $ctg;
    }
}

while (<STDIN>) { #no_categ_rest_7000
    chomp;
    #my ($_yql_column_0, $bid, $title, $body, $bnorm, $ctg, $href) = split /\t/;
    my ($_yql_column_0, $bid, $title, $body, $ctg, $href) = split /\t/;

    my $url = URI->new($href);
    if ($url) {
        my $path = $url->path();
        $path =~ s{/$}{};

        my $sign = $url->host().$path; #сигнатура
        if ($url2ctg{$sign}) {
            if ($sign eq "ostrovok.ru/welcome") {
                my $ctg_uniq;
                if ("$title $body" =~ /(Москв|Петербур)/i) {
                    $ctg_uniq = "Гостиницы Москвы и Санкт-Петербурга";
                } elsif ("$title $body" =~ /(Донецк)/i) {
                    $ctg_uniq = "Отели, гостиницы";
                } else {
                    $ctg_uniq = "Гостиницы России";
                }
                print "$_yql_column_0\t$bid\t$title\t$body\t$ctg_uniq\t$href\n";
            } else {
                print "$_yql_column_0\t$bid\t$title\t$body\t$url2ctg{$sign}\t$href\n";
            }
        } else {
            print STDERR "$_\n"
        }
    } else {
        print STDERR "$_\n"
    }
}
