#!/usr/bin/python
# -*- coding: utf-8 -*-

#отображение урлов в категории по аналогии с соседями и категорией с MAX частотой

import sys
import re
import random
import yt.wrapper as yt
import json

from urlparse import urlparse #см. url_pars.py


def url2ctgs(rec): #выбор элементов урла и основных полей таблицы для последующего анализа
    if rec['domain'] is not None and rec['domain'] != '':
        if rec['mctgs'] is not None and rec['mctgs'] != '':
            yield { "domain": rec['domain'], "href": rec['href'], "mctgs": rec['mctgs'], "bid": rec['bid'], "title": rec['title'], "body": rec['body'] }


def href2ctg(key, recs): #выбор категории по урлу
    no_ctgs = [] #некатегоризованные баннеры с присвоенными категориями
    i = 0 #текущий индекс записи в no_ctgs

    ctg_freq = {} #частотный словарь категорий домена, упорядоченных по убыванию частоты

    #--- предыдущий сосед в url2ctgs ---
    ctg_prev = 'NO_CTG' #категория
    href_prev = 'NO_HREF' #урл
    num_prev = 0 #номер записи

    num_curr = 0 #текущий номер записи в url2ctgs
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0: #записи no_categ_rest_7000href (bnrs_select.py)
            no_ctgs.append(rec)
        else: #записи url2ctgs
            num_curr += 1

            ctgs = rec['mctgs'].split('/') #для построения частотного словаря категорий домена
            for ctg in ctgs:
                if ctg in ctg_freq:
                    ctg_freq[ctg] += 1
                else:
                    ctg_freq[ctg] = 1

            while 1:
                if i >= len(no_ctgs):
                    break
                if no_ctgs[i]['href'] >= rec['href']:
                    ctg_prev = rec['mctgs']
                    href_prev = rec['href']
                    num_prev = num_curr
                    break
                else:
                    no_ctgs[i]['mctgs'] = ctg_prev + '\t' + rec['mctgs'] + '\t' + href_prev + '\t' + rec['href'] + '\t' + str(num_prev)+ '\t' + str(num_curr)
                    i = i + 1
        #if i >= len(no_ctgs): #если построение частотного словаря не нужно
        #    break

    sorted_keys = sorted(ctg_freq, lambda x, y: -cmp(int(ctg_freq[x]), int(ctg_freq[y])) or cmp(x, y)) #сортировка ПО УБЫВАНИЮ частот ("-" перед cmp)
    pairs = []
    for ctg in sorted_keys:
        pairs.append(ctg) #категория
        pairs.append(str(ctg_freq[ctg])) #частота
    try:
        ctgs_list = '\t'.join(pairs) #категории домена, упорядоченные по убыванию частоты
    except:
        ctgs_list = 'NO_CTG\t0'

    for j in range(i, len(no_ctgs)): #баннеры, урлы которых больше самого большого урла в домене
        no_ctgs[j]['mctgs'] = ctg_prev + '\t' + 'NO_CTG' + '\t' + href_prev + '\t' + 'NO_HREF' + '\t' + str(num_prev)+ '\t' + str(num_curr)

    ctgs_freq = ctgs_list.split('\t') #ПАРЫ - частотный список категорий: <категория, частота>

    for rec in no_ctgs:
        rec['ctgs_list'] = ctgs_list
        #yield rec #выводим ВСЕ найденные категории

        ctgs = rec['mctgs'].split('\t')
        ctgs_tot = list(set(ctgs[0].split('/') + ctgs[1].split('/'))) #полный список уникальных категорий от обоих соседей
        flag = 0
        for ctg in ctgs_tot: #одна из двух категорий совпадает с самой частотной (м.б. омонимия категорий)
            if ctg == ctgs_freq[0]:
                flag = 1
                #yield rec
                break
        if flag == 1:
            continue

        for ctg in ctgs_tot: #одна из двух категорий совпадает со ВТОРОЙ самой частотной (м.б. омонимия категорий)
            if len(ctgs_freq) > 2 and ctg == ctgs_freq[2]:
                yield rec
                break

        #if ctgs[0] != 'NO_CTG' and ctgs[0] == ctgs[1] and ctgs[0] == ctgs_freq[0]: #categ_rest_7000 = категории у соседей совпадают И первая категория совпадает с самой частотной
        #if ctgs[0] != 'NO_CTG' and ctgs[0] != ctgs[1] and ctgs[0] == ctgs_freq[0]: #categ_rest_7000_2 = категории у соседей НЕ совпадают И первая категория совпадает с самой частотной
        #if ctgs[0] != 'NO_CTG' and ctgs[0] == ctgs[1] and ctgs[0] != ctgs_freq[0]: #categ_rest_7000_3 = категории у соседей совпадают И первая категория НЕ совпадает с самой частотной
        #if ctgs[0] != 'NO_CTG' and ctgs[0] == ctgs[1] and len(ctgs_freq) > 2 and ctgs[0] == ctgs_freq[2]: #categ_rest_7000_4 = категории у соседей совпадают И первая категория совпадает со ВТОРОЙ самой частотной
        #if ctgs[0] != 'NO_CTG' and ctgs[0] != ctgs[1] and len(ctgs_freq) > 2 and ctgs[0] == ctgs_freq[2]: #categ_rest_7000_5 = категории у соседей НЕ совпадают И первая категория совпадает со ВТОРОЙ самой частотной
        #if ctgs[0] != 'NO_CTG' and ctgs[0] != ctgs[1] and ctgs[1] == ctgs_freq[0]: #categ_rest_7000_6 = категории у соседей НЕ совпадают И ВТОРАЯ категория совпадает с самой частотной
        #if ctgs[0] != 'NO_CTG' and ctgs[0] != ctgs[1] and len(ctgs_freq) > 2 and ctgs[1] == ctgs_freq[2]: #categ_rest_7000_7 = категории у соседей НЕ совпадают И ВТОРАЯ категория совпадает со ВТОРОЙ самой частотной
        #    yield rec


def main():
    tab1 = '//home/catalogia/banners_extended'
    tab2 = '//tmp/yuryz/url2ctgs'

    #yt.run_map(url2ctgs, tab1, [tab2], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab2, tab2, sort_by=['domain', 'href', 'mctgs', 'bid']) ### ВОЗМОЖНО здесь будет нужно проверять каких категорий внутри href больше и только ИХ оставлять

    tab3 = '//tmp/yuryz/no_categ_rest_7000href' #bnrs_select.py
    tab4 = '//tmp/yuryz/categ_rest_7000_10'

    yt.run_reduce(href2ctg, [tab3, tab2], [tab4], reduce_by = ['domain'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab4, sort_by=['_yql_column_0', 'bid'])

    print >> sys.stderr, yt.row_count(tab1)
    print >> sys.stderr, yt.row_count(tab2)

    print >> sys.stderr, yt.row_count(tab3)
    print >> sys.stderr, yt.row_count(tab4)


if __name__ == '__main__':
    main()
