#! /usr/bin/env perl

use lib 'scripts/lib';

use utf8;
use Project;

my $proj = Project->new({
    load_dicts                              => 1,
    load_minicategs_light                   => 1,
    allow_lazy_dicts                        => 1,
    use_comptrie_subphraser                 => 1,
    use_sandbox_categories_suppression_dict => 1,
});
$proj->categs_tree->never_read_categs_cache(1);
$proj->categs_tree->never_write_categs_cache(1);

while (my $line = <STDIN>) {
    chomp($line);
    my @a = split /\t/, $line;
    my $title_ext;
    for my $a (@a) {
        $title_ext = substr($a, 16) if $a =~ /^title_extension=/;
    }

    my $title_ext_nrm = "";
    if ($title_ext) {
        my $title_ext_pre = $proj->phrase($title_ext)->get_banner_prefiltered_phrase->text; # title_ext
        my $title_ext_nrm = $proj->phrase($title_ext_pre)->norm_phr_ordered; # title_ext    
        print "$line\ttitle_extension_norm=$title_ext_nrm\n";
    }

    #print "$line\ttitle_extension_norm=$title_ext_nrm\n";
}
