#! /usr/bin/env perl

use lib 'scripts/lib';

use utf8;
use Project;

my $proj = Project->new({
    load_dicts                              => 1,
    load_minicategs_light                   => 1,
    allow_lazy_dicts                        => 1,
    use_comptrie_subphraser                 => 1,
    use_sandbox_categories_suppression_dict => 1,
});
$proj->categs_tree->never_read_categs_cache(1);
$proj->categs_tree->never_write_categs_cache(1);

while (my $line = <STDIN>) {
    chomp($line);
    my @a = split /\t/, $line;
    my $title;
    my $body;
    my $url;
    for my $a (@a) {
        $title = substr($a, 6) if $a =~ /^title=/;
        $body = substr($a, 5) if $a =~ /^body=/;
        $url = substr($a, 5) if $a =~ /^href=/;
    }

    #$url = "http://aventin-pskov.ru/real-estate/buy/home-in-the-city/4227/";
    $url = "http://live.q-house.ru/";
    my @ctgs = $proj->page($url)->get_minicategs; #  landing page
    my $ctgs = join("/", @ctgs);

    #print "$line\tmctgs_land=".join("/", @ctgs)."\n";
    print "$line\turl=$url\tCTGS=$ctgs\n";
}
