#! /usr/bin/env perl

use lib 'scripts/lib';

use utf8;
use Project;

my $proj = Project->new({
    load_dicts                              => 1,
    load_minicategs_light                   => 1,
    allow_lazy_dicts                        => 1,
    use_comptrie_subphraser                 => 1,
    use_sandbox_categories_suppression_dict => 1,
});
$proj->categs_tree->never_read_categs_cache(1);
$proj->categs_tree->never_write_categs_cache(1);

while (my $line = <STDIN>) {
    chomp($line);
    my @a = split /\t/, $line;
    my $phrases;
    for my $a (@a) {
        $phrases = substr($a, 8) if $a =~ /^phrases=/;
    }

    $phrases =~ s/\+//; #возможно в будущем здесь понадобится пословная нормализация с помощью $proj->phrase($word)->norm_phr_safe
    my $phrases_norm = $proj->phrase($phrases)->norm_phr; #список уникальных нормализованных слов всех фраз

    print "$line\tphrases_norm=$phrases_norm\n";
}

