#!/usr/bin/python
# -*- coding: utf-8 -*-

#выбор баннеров для тестирования

import random
import yt.wrapper as yt


class bnrs_sel(object):
    def __init__(self, prob):
        self.prob = prob

    def __call__(self, rec):
        if random.uniform(0, self.prob) < 1: #вероятность = 1 / prob
            yield { "bid": rec['bid'], "title": rec['title'], "body": rec['body'], "mctgs_tag": rec['mctgs'], "domain": rec['domain'], "mctgs": rec['mctgs'] }


def main():
    t1 = '//home/catalogia/users/yuryz/tmp/bnrs_norm'
    t2 = '//tmp/yuryz/bnrs4test'

    BNRS4TEST = 50000.0 #число баннеров для тестирования
    prob = yt.row_count(t1) / BNRS4TEST #вероятность выбора баннеров

    yt.run_map(bnrs_sel(prob), t1, t2)
    #yt.run_sort(t2, sort_by=['bid'])

    #print yt.row_count(t1)
    #print yt.row_count(t2)

    for rec in yt.read_table(t2, raw=False):
        print str(rec['bid']) + '\t' + rec['title'] + '\t' + rec['body'] + '\t' + rec['mctgs_tag'] + '\t' + rec['domain'] + '\t' + rec['mctgs']


if __name__ == '__main__':
    main()
