#!/usr/bin/python
# -*- coding: utf-8 -*-

#первичный выбор баннеров из BANNERS_EXTENDED

import sys
import re
import yt.wrapper as yt

from urlparse import urlparse

class bnrs_select(object): #выбор баннеров
    def __init__(self, bnr_type):
        self.bnr_type = bnr_type # 1 - обычные баннеры, 2 - омонимичные баннеры, 3 - те и другие

    def __call__(self, rec):
        if rec['mctgs'] and rec['mctgs'] != '' and rec['title'] and rec['title'] != '' and rec['body'] and rec['body'] != '':
            slash = rec['mctgs'].find('/')
            if self.bnr_type == 1 and slash == -1 or self.bnr_type == 2 and slash > 0 or self.bnr_type == 3:
                yield { "bid": rec['bid'], "title": rec['title'], "body": rec['body'], "mctgs": rec['mctgs'], "domain": rec['domain'], "phrases": rec['phrases'] }


def del_dup(key, recs): #удаление полных дублей
    yield recs.next()


def main():
    tab1 = sys.argv[2] #'//home/catalogia/banners_extended'
    tab2 = '//tmp/yuryz/bnrs_select' #выбранные баннеры

    yt.run_map(bnrs_select(int(sys.argv[1])), tab1, tab2) # 1 - обычные баннеры, 2 - омонимичные баннеры, 3 - те и другие
    yt.run_sort(tab2, sort_by=['title', 'body', 'mctgs'])

    print yt.row_count(tab1)
    print yt.row_count(tab2)

    tab3 = sys.argv[3] #баннеры БЕЗ дублей

    yt.run_reduce(del_dup, tab2, tab3, reduce_by=['title', 'body', 'mctgs'])
    yt.run_sort(tab3, sort_by=['bid'])

    print yt.row_count(tab3)


if __name__ == '__main__':
    main()
