#!/usr/bin/perl -w
#категоризация по аналогии (с помощью ближайших категоризованных соседей в кампаниях)

use strict;
use utf8;
use open ":utf8";
no warnings 'utf8';

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ":utf8";

#use FindBin;
#use lib "$FindBin::Bin/../lib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";

use Utils::Common;
use Project;
use BM::Phrase;
use BM::PhraseList;
use Time::HiRes qw(tv_interval gettimeofday);

my $proj = Project->new({
    load_dicts   => 1,
    load_minicategs_light => 1, 
});

my $bad_categs = qr/(NO_CATEGS|курьерские услуги|поиск работы|продвижение сайтов|Подарки, сувениры, цветы|Услуги базаров, рынков|Серверы|Реклама в интернете|Сырье, концентраты|NCAP Автомобили малого класса|Скидочные купоны)/;
#my $bad_categs = qr/(NO_CATEGS|курьерские услуги)/;

my $worker = Utils::Worker->new;
$worker->{verbose}    = 1;
$worker->{num_processes}    = 12;

$worker->{file_input}       = "/home/yuryz/scripts/data/uncat_bnrs_1kk.active.land.uniq";
$worker->{file_output}      = "/home/yuryz/scripts/data/uncat_bnrs_1kk.active.land.uniq.nbrs2";

$worker->{process_line}     = sub {
    my ($line, $fh) = @_;
    chomp $line;

    my ($bid, $btext, $burl, $bcateg) = split /\t/, $line;

    unless ($bcateg =~ /$bad_categs$/) {
        print $fh join("\t", $bid, $btext, $burl, $bcateg), "\n";
        return;
    }

    my $bnr = $proj->bf->get_banner_by_id($bid);
    return unless defined ( $bnr );

    my $campaign = $bnr->campaign_obj;
    return unless defined ($campaign);

    my $campaign_bnl = $campaign->bnl;
    return unless defined ( $campaign->bnl );

    my @banners = sort { $a->id cmp $b->id } @{$campaign_bnl};
    my ($ind_up, $ind_down) = bin_search($bid, \@banners); #ближайшие соседи

    my $ind;
    my $text;
    my @categs;

    #верхний сосед
    $ind = $ind_up;
    while ($ind >= 0) {
        return unless defined ($banners[$ind]);
        $text = $banners[$ind]->banner_text_phrase->text;
        @categs = $proj->phrase($text)->get_minicategs;
        last if @categs && $categs[0] !~ /$bad_categs/;
        $ind--;
    }
    if ($ind < 0) {
        $ind = $ind_up;
        @categs = ( 'NO_CATEGS' );
    }
    my $text_up = $banners[$ind]->banner_text_phrase->text;
    my $categs_up = join("\t", @categs);

    #нижний сосед
    $ind = $ind_down;
    while ($ind <= $#banners) {
        return unless defined ($banners[$ind]);
        $text = $banners[$ind]->banner_text_phrase->text;
        @categs = $proj->phrase($text)->get_minicategs;
        last if @categs && $categs[0] !~ /$bad_categs/;
        $ind++;
    }
    if ($ind > $#banners) {
        $ind = $ind_down;
        @categs = ( 'NO_CATEGS' );
    }
    my $text_down = $banners[$ind]->banner_text_phrase->text;
    my $categs_down = join("\t", @categs);

    #присвоение категории соседей
    if ($categs_up ne 'NO_CATEGS' && $categs_down ne 'NO_CATEGS') {
        if ($categs_up eq $categs_down) {
            $bcateg = $categs_up;
        } else {
            my $simil_up = bnrs_simil_lev($btext, $text_up);
            my $simil_down = bnrs_simil_lev($btext, $text_down);
            $bcateg = $simil_up >= $simil_down ? $categs_up : $categs_down;
        }
    } elsif ($categs_up ne 'NO_CATEGS' && $categs_down eq 'NO_CATEGS') {
        $bcateg = $categs_up;
    } elsif ($categs_up eq 'NO_CATEGS' && $categs_down ne 'NO_CATEGS') {
        $bcateg = $categs_down;
    }

    print $fh join("\t", $bid, $btext, $burl, $bcateg), "\n";
};

print STDERR "Starting...\n";

$worker->process_data;


#--- бинарный поиск ближайших категоризованных баннеров в кампании ---
sub bin_search
{
    my ($bid, $banners) = @_; #$bid - ID баннера; $banners - отсортированный по ID список баннеров из одной кампании
    
    my $first = 0;
    my $last = $#{$banners};
    while ($first <= $last) {
        my $mid = int(($first + $last) / 2);
        if ($bid lt $$banners[$mid]->id) {
            $last = $mid - 1;
        } elsif ($bid gt $$banners[$mid]->id) {
            $first = $mid + 1;
        } else { #совпадение
            $last = $mid - 1;
            $first = $mid + 1;
            last;
        }
    }
    
    $last = 0 if $last < 0;
    $first = $#{$banners} if $first > $#{$banners};

    return ($last, $first);
}


#--- определение сходства текстов баннеров ---
sub bnrs_simil {
    my ($bnr_text1, $bnr_text2) = @_;

    my $dict1 = bnr_dict($bnr_text1);
    my $dict2 = bnr_dict($bnr_text2);
    ($dict1, $dict2) = ($dict2, $dict1) if keys %{$dict1} > keys %{$dict2};

    my $simil = 0; #сходство
    for (keys %{$dict1}) {
        if ($$dict2{$_}) {
            $simil += $$dict1{$_} < $$dict2{$_} ? $$dict1{$_} : $$dict2{$_};
        }
    }

    return $simil;
}


#--- частотный словарь баннера ---
sub bnr_dict {
    my ($bnr_text) = @_;

    my $valid_chars = qr/0-9a-zа-яё \-/; #допустимые символы

    my %dict;
    
    $bnr_text = lc($bnr_text);
    #$bnr_text =~ s/\.[$valid_chars]+(?=[^$valid_chars])//g; #чистка
    $bnr_text =~ s/[^$valid_chars]/ /g;
    $bnr_text =~ s/^ +//;
    $bnr_text =~ s/ +$//;
    $bnr_text =~ s/ +/ /g;

    map { $dict{$_}++ } split / /, $bnr_text;
    
    return \%dict;
}


#--- определение сходства текстов баннеров ---
sub bnrs_simil_lev {
    my ($bnr1_text, $bnr2_text) = @_;

    $bnr1_text = bnr_text_clean($bnr1_text);
    $bnr2_text = bnr_text_clean($bnr2_text);

    return 1-levenshtein($bnr1_text, $bnr2_text)/(length($bnr1_text)+length($bnr2_text));
}


#--- очистка текста баннера ---
sub bnr_text_clean {
    my ($bnr_text) = @_;

    my $valid_chars = qr/0-9a-zа-яё \-/; #допустимые символы
    
    $bnr_text = lc($bnr_text);
    #$bnr_text =~ s/\.[$valid_chars]+(?=[^$valid_chars])//g; #чистка
    $bnr_text =~ s/[^$valid_chars]/ /g;
    $bnr_text =~ s/^ +//;
    $bnr_text =~ s/ +$//;
    $bnr_text =~ s/ +/ /g;
    
    return $bnr_text;
}


#редакционное расстояние
sub levenshtein
{
    my ($a, $b)=@_;

    my @bellman;
    my $la=length $a;
    my $lb=length $b;

    $bellman[$_][0]=$_ for 0..$la;
    $bellman[0][$_]=$_ for 0..$lb;

    for my $j(1..$lb)
    {
        for my $i(1..$la)
        {
            $bellman[$i][$j]=$bellman[$i-1][$j]+1;
            $bellman[$i][$j]=$bellman[$i][$j-1]+1
                if $bellman[$i][$j]>$bellman[$i][$j-1]+1;

            if(substr($a, $i-1, 1) eq substr($b, $j-1, 1))
            {
                $bellman[$i][$j]=$bellman[$i-1][$j-1]
                    if $bellman[$i][$j]>$bellman[$i-1][$j-1];
            }
        }
    }
    return $bellman[$la][$lb];
}
