#!/usr/bin/perl -w
#подготовка баннеров для обработки

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});

my %filter;
open F, "sem_core_word_list"; #словарь ВСЕХ слов в ядрах Каталогии (см. read_core_index.py)
while (<F>) {
    chomp;
    $filter{$_} = 1;
}

my $cnt = 0;
my $flen = (stat(STDIN))[7]; #длина файла
while (<STDIN>) { #ztest
    progress(tell(STDIN), $flen, 'Предобработка баннеров') if ++$cnt % 10 == 0;
    chomp;

    my ($bid, $title, $body, $mctgs_tag, $bnr_domain, $mctgs) = split /\t/;

    my $title_pre = $proj->phrase($title)->get_banner_prefiltered_phrase->text; #префильтрация title
    my $title_nrm = $proj->phrase($title_pre)->norm_phr_ordered; #нормализация title с учетом порядка слов

    my $body_pre = $proj->phrase($body)->get_banner_prefiltered_phrase->text; #префильтрация body
    my $body_nrm = $proj->phrase($body_pre)->norm_phr_ordered; #нормализация body с учетом порядка слов

    my %dup;
    my @uniq = grep { !$dup{$_}++ } split / /, "$title_nrm $body_nrm"; #удаление дублей из нормализованного текста

    my @good; #слова баннера, которые МОГУТ входить в какие-либо ядра ("хорошие" слова)
    my @uniq_clean; #слова из @uniq, очищенные от посторонних знаков
    for my $uniq (@uniq) {
        $uniq =~ s/^[!+\$]+//; #см. tf_idf_1.py
        next if length($uniq) <= 1 || $uniq =~ /^([0-9.]+|самовывоз|сегодня|всегда|каждый|минута|нечего|оплата|сейчас|более|здесь|любой|много|стать|также|есть|жать|ваш|где|мес|мин|раз|руб|тут|тыс|час|др|кв|кг|км|м2|мм|пр|см|ул)$/ || $uniq =~ /^_/ || $uniq eq "moderatebadwordtype"; #см. tf_idf_1.py
        push @uniq_clean, $uniq;
        if ($filter{$uniq}) { #фильтрация слов, не входящих НИ В КАКИЕ семантические ядра
            push @good, $uniq;
        }
    }
    my $goods = join(" ", @uniq_clean); #слова, потенциально содержащие ядра ###

    my $rest = "$title_nrm\t$body_nrm\t\t"; #title_norm, body_norm, title_extension_norm, phrases_norm
    for my $i (0..$#good-1) { #генерация пар слов для поиска семантического ядра (*здесь и нужны слова @good*)
        for my $j ($i+1..$#good) {
            print "$good[$i] $good[$j]\t$goods\t$_\t$rest\n"; #$good[$i] $good[$j]\t$goods - это two_word_index, $goods - uniq_clean
            print "$good[$j] $good[$i]\t$goods\t$_\t$rest\n";
        }
        print "$good[$i]\t$goods\t$_\t$rest\n"; #учет ОДНОСЛОВНЫХ ядер
    }
    if (@good > 0) { #учет ОДНОСЛОВНЫХ ядер
        print "$good[$#good]\t$goods\t$_\t$rest\n";
    }
}
print STDERR "\n";


#--- ProgressBar ---
sub progress {
    my ($count, $total, $status) = @_;
    my $bar_len = 50;
    my $filled_len = int(sprintf("%.f", $bar_len * $count / $total));

    my $percents = sprintf "%.1f", 100.0 * $count / $total;
    my $bar = ('■' x $filled_len).('-' x ($bar_len - $filled_len));

    printf STDERR "[%s] %s%s %s\r", $bar, $percents, '%', $status;
    STDERR->flush();
}
