#!/usr/bin/python
# -*- coding: utf-8 -*-

#категоризация с помощью семантических ядер

import sys
import re
import math
import copy

import yt.wrapper as yt

CTGS_MAX = 2 #максимальное число категорий для баннера

def core_find(key, recs): #поиск семантических ядер в словаре
    bnrs = []
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0: #собираем вместе баннеры, имеющие одинаковые two_word_index
            bnrs.append(rec)
        elif len(bnrs) > 0: #для каждого two_word_index ищем подходящие ядра
            core_wrds = rec['clast_phrase'].split() #слова ядра
            trash_wrds = rec['trash'].split() #слова периферии с весами
            domains = rec['domain'].split() #домены ядра

            for bnr in bnrs:
                bnr_wrds = bnr['uniq_clean'].split() #слова баннера (см. categ_sem_core1.pl)
                flag = 0
                for core_wrd in core_wrds:
                    if core_wrd not in bnr_wrds: #ВСЕ слова ядра должны входить в слова баннера
                        flag = 1
                        break
                if flag == 1: continue #в баннер bnr ядро rec['clast_phrase'] НЕ ВХОДИТ

                wrds_find = rec['clast_phrase'].split() ###найденные слова баннера (пока те, которые из ядра)

                count_trash = 0; #счетчик слов баннера, не вошедших в ядро, но вошедших в trash или в deprec_expand
                for i in range(0, len(trash_wrds), 2):
                    if trash_wrds[i] in bnr_wrds:
                        count_trash += 1
                        wrds_find.append(trash_wrds[i])

                for bnr_wrd in bnr_wrds: #вывод не найденных слов баннера для дальнейшего поиска в депрекейтах
                    if bnr_wrd not in wrds_find:
                        yield { "word": bnr_wrd, "bid": bnr['bid'], "mctgs": rec['mctgs'], "core": rec['clast_phrase'], "bnr": bnr['uniq_clean'], "@table_index": 1 }

                domain = ""
                domain_find = 0
                if bnr['domain'] in domains: #домен баннера входит в список доменов ядра
                    domain = bnr['domain']
                    domain_find = -1

                bnr2 = copy.deepcopy(bnr) ###
                bnr2['mctgs'] = rec['mctgs'] #*** категория ядра ***
                bnr2['domain'] = domain
                bnr2['domain_find'] = domain_find
                bnr2['cover_core_trash'] = -(len(core_wrds)+count_trash)
                bnr2['cover_core'] = -len(core_wrds)
                bnr2['cluster_size'] = rec['clast_size']
                bnr2['core'] = rec['clast_phrase']
                bnr2['clast_weight'] = rec['clast_weight'] #####

                yield bnr2


def deprec_filter(key, recs): #фильтрация depricated слов
    ctgs = {}
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0: #словарь депрекейтов
            ctgs[rec['mctgs']] = 1
        else:
            if len(ctgs) > 0 and rec['mctgs'] not in ctgs:
                yield rec


def clarif(key, recs): #уточнение категоризации
    depr_count = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0: #слова, прошедшие через фильтр депрекейтов
            depr_count += 1
        else: #результаты предварительной категоризации
            rec['cover_core_trash'] -= depr_count #"-" - из-за сортировки по убыванию
            yield rec


def only_first(key, recs): #оставляем только первые CTGS_MAX найденных категорий
    bnr = None
    dup = {} #исключение дубликатов категорий
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0: #баннер из исходного набора ztest
            bnr = rec
        elif bnr != None: #баннер из списка найденных и ранжированных
            if rec['mctgs'] not in dup and len(dup) < CTGS_MAX: #максимальное число категорий для баннера
                dup[rec['mctgs']] = 1
                rec['clast_size'] = rec['cluster_size']
                del rec['cluster_size']
                rec['clast_phrase'] = rec['core']
                del rec['core']

                if len(dup) == 1: #первая запись в результатах категоризации
                    ctgs = rec['mctgs_tag'].split('/') #несколько категорий считаются РАЗНЫМИ категориями
                    if rec['mctgs'] not in ctgs: #обучение только НА ОШИБОЧНЫХ
                        ##yield rec
                        pass
                    ##yield rec #обучение НА ВСЕХ результатах категоризации
                yield rec #обучение НА ВСЕХ результатах категоризации

    if len(dup) == 0: #баннер из исходного списка ztest, для которого не было найдено НИ ОДНОГО ЯДРА
        bnr['@table_index'] = 1
        yield bnr


def main():
    #--- 1. Поиск семантических ядер ---
    tab1 = '//tmp/yuryz/ztest_join' #тестовая выборка (см. categ_sem_core.sh)
    tab2 = '//home/catalogia/users/yuryz/tmp/sem_core_clast_size' #словарь семантических ядер (см. read_core_index.py)

    tab3 = '//tmp/yuryz/ztest_join_find' #результаты поиска записей из tab1 в tab2
    tab4 = '//tmp/yuryz/ztest_4deprec' #для поиска в депрекейтах

    yt.run_reduce(core_find, [tab1, tab2], [tab3, tab4], reduce_by = ['two_word_index'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab3, sort_by=['bid', 'core'])
    yt.run_sort(tab4, sort_by=['word', 'bid'])

    #--- 2. Фильтрация depricated слов ---
    tab5 = '//home/catalogia/users/yuryz/tmp/deprec_expand'
    tab6 = '//tmp/yuryz/wrd2ctg'

    yt.run_reduce(deprec_filter, [tab5, tab4], tab6, reduce_by = ['word'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab6, sort_by=['bid', 'core', 'word'])

    #--- 3. Уточнение категоризации ---
    tab7 = '//tmp/yuryz/ztest_join_categ'

    yt.run_reduce(clarif, [tab6, tab3], tab7, reduce_by = ['bid', 'core'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab7, sort_by=['bid', 'domain_find', 'cover_core_trash', 'cover_core', 'cluster_size'])

    #--- 4. Оставляем только первые записи из списка найденных и ранжированных ---
    tab_src = '//tmp/yuryz/ztest' #см. categ_sem_core.sh
    tab8 = '//home/catalogia/users/yuryz/contest/ztest_join_categ'
    tab_not_found = '//home/catalogia/users/yuryz/contest/bnrs_not_found'

    yt.run_reduce(only_first, [tab_src, tab7], [tab8, tab_not_found], reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab8, sort_by=['bid', 'domain_find', 'cover_core_trash', 'cover_core', 'clast_size'])

    #--- 5. Результаты категоризации ---
    for rec in yt.read_table(tab8, raw=False): #баннеры, для которых нашлись ядра
        print str(rec['bid']) + '\t' + rec['title'] + '\t' + rec['body'] + '\t' + rec['mctgs_tag'] + '\t' + rec['domain'] + '\t' + rec['mctgs'] + '\t' + rec['clast_phrase']

    for rec in yt.read_table(tab_not_found, raw=False): #баннеры, для которых не нашлось ни одного ядра
        print str(rec['bid']) + '\t' + rec['title'] + '\t' + rec['body'] + '\t' + rec['mctgs_tag'] + '\t' + rec['domain'] + '\t' + rec['mctgs'] + '\t' + 'NO_CORE'


if __name__ == '__main__':
    main()
