#!/usr/bin/perl -w
#поиск в словаре семантических ядер

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

my %ctg;
open F, "ctg_list";
while (<F>) {
    chomp;
    my ($ctg, $ctg_id) = split /\t/;
    $ctg{$ctg_id} = $ctg;
    $ctg{$ctg} = $ctg_id; #--- для учета депрекейтов ---
}

my %deprec;
open F, "deprec_expand"; #учет депрекейтов ( deprec_expand.pl <dict_deprecated_categs_words_ru |LC_ALL=C sort -u >deprec_expand )
my $cnt = 0;
my $flen = (stat(F))[7];
while (<F>) {
    progress(tell(F), $flen, 'Загрузка словаря deprec_expand') if ++$cnt % 1000 == 0;
    chomp;
    my ($word, $ctg_name) = split /\t/;
    my $ctg = $ctg{$ctg_name} ? $ctg{$ctg_name} : $ctg_name; #перекодировка имени в ID
    $deprec{$word}{$ctg} = 1; #$ctg может быть равна ДЖОКЕРУ "*"!!!
}
print STDERR "\n";

open F, "core_index_id"; #словарь семантических ядер
my $rec; #записи словаря семантических ядер
my ($core, $ctg, $size, $trash, $domain) = (""); #структура записи словаря семантических ядер

$cnt = 0;
$flen = (stat(STDIN))[7]; #длина файла
print STDERR scalar localtime, "\n"; ###
OUT:while (<STDIN>) { #ztest_join1.srt
    progress(tell(STDIN), $flen, 'Обработка баннеров') if ++$cnt % 30 == 0;
    chomp;
    my ($two_word, $goods, $bid, $title, $body, $mctgs, $bnr_domain, $mctgs_prev) = split /\t/; ### поля mctgs_prev может не быть

    L:if ($two_word gt $core) {
        chomp($rec = <F>);
        ($core, $ctg, $size, $trash, $domain) = split /\t/, $rec; #--- новое семантическое ядро ---
        goto L;
    } else { #$two_word le $core
        my @two_word = split / /, $two_word;
        my @core = split / /, $core;

        if ( @two_word == 1 && $two_word ne $core[0] || @two_word == 2 && (@core == 1 || $two_word ne "$core[0] $core[1]") ) {
            next OUT;
        }

        my @goods = split / /, $goods; #$goods - это на самом деле очищенное поле $uniq (см. categ_sem_core1.pl)
        my %goods;
        $goods{$_} = 1 for @goods;
        my $i0 = @two_word+0; #смещение для начала цикла
        for my $i ($i0...$#core) { #т.к. слова 0..$i0-1 - уже совпадают с $two_word
            next OUT unless $goods{$core[$i]}; #ВСЕ слова ядра должны входить в список $goods
        }

        #--- выделено ядро $core ---
        my @trash = split / /, $trash;
        my $count_trash = 0; #счетчик слов баннера, не вошедших в ядро, но вошедших в $trash или в deprec_expand
        for (my $i = 0; $i < @trash; $i += 2) {
            if ($goods{$trash[$i]}) {
                $goods{$trash[$i]}++; #для слов из @goods, которые НЕ будут проверяться по депрекейтам
                $count_trash++;
            }
        }

        for (keys %goods) { #дополнительная проверка по депрекейтам
            $count_trash++ if $goods{$_} == 1 && $deprec{$_} && !$deprec{$_}{$ctg};
        }

        my $dmn = "";
        for (split / /, $domain) { #список доменов из ядра
            if ($bnr_domain eq $_) { #домен баннера найден в списке доменов ядра
                $dmn = $bnr_domain;
                last;
            }
        }

        print "$_\n";
        print "[$core]\t$ctg\t$size\t[$count_trash]\t[$dmn]\n";
        print "--\n";

        chomp($rec = <F>);
        ($core, $ctg, $size, $trash, $domain) = split /\t/, $rec; #--- новое семантическое ядро ---
    }
}
print STDERR "\n";
print STDERR scalar localtime, "\n"; ###


#--- ProgressBar ---
sub progress {
    my ($count, $total, $status) = @_;
    my $bar_len = 50;
    my $filled_len = int(sprintf("%.f", $bar_len * $count / $total));

    my $percents = sprintf "%.1f", 100.0 * $count / $total;
    my $bar = ('■' x $filled_len).('-' x ($bar_len - $filled_len));

    printf STDERR "[%s] %s%s %s\r", $bar, $percents, '%', $status;
    STDERR->flush();
}
