#!/usr/bin/python
# -*- coding: utf-8 -*-

#категоризация с помощью семантических ядер

import sys
import re
import math
import copy

import yt.wrapper as yt

CTGS_MAX = 1 #максимальное число категорий для баннера

def core_find(key, recs): #поиск семантических ядер в словаре
    bnrs = []
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0: #собираем вместе баннеры, имеющие одинаковые two_word_index
            bnrs.append(rec)
        elif len(bnrs) > 0: #для каждого two_word_index ищем подходящие ядра
            core_wrds = rec['clast_phrase'].split() #слова ядра
            trash_wrds = rec['trash'].split() #слова периферии с весами
            domains = rec['domain'].split() #домены ядра

            for bnr in bnrs:
                bnr_wrds = bnr['uniq_clean'].split() #слова баннера (см. categ_sem_core1.pl)
                flag = 0
                for core_wrd in core_wrds:
                    if core_wrd not in bnr_wrds: #ВСЕ слова ядра должны входить в слова баннера
                        flag = 1
                        break
                if flag == 1: continue #в баннер bnr ядро rec['clast_phrase'] НЕ ВХОДИТ

                wrds_find = rec['clast_phrase'].split() ###найденные слова баннера (пока те, которые из ядра)

                count_trash = 0; #счетчик слов баннера, не вошедших в ядро, но вошедших в trash или в deprec_expand
                for i in range(0, len(trash_wrds), 2):
                    if trash_wrds[i] in bnr_wrds:
                        count_trash += 1
                        wrds_find.append(trash_wrds[i])

                for bnr_wrd in bnr_wrds: #вывод не найденных слов баннера для дальнейшего поиска в депрекейтах
                    if bnr_wrd not in wrds_find:
                        yield { "word": bnr_wrd, "bid": bnr['bid'], "mctgs": rec['mctgs'], "core": rec['clast_phrase'], "bnr": bnr['uniq_clean'], "@table_index": 1 }

                domain = ""
                domain_find = 0
                if bnr['domain'] in domains: #домен баннера входит в список доменов ядра
                    domain = bnr['domain']
                    domain_find = -1

                bnr2 = copy.deepcopy(bnr) ###
                bnr2['mctgs'] = rec['mctgs'] #*** категория ядра ***
                bnr2['domain'] = domain
                bnr2['domain_find'] = domain_find
                bnr2['cover_core_trash'] = -(len(core_wrds)+count_trash)
                bnr2['cover_core'] = -len(core_wrds)
                bnr2['cluster_size'] = rec['clast_size']
                bnr2['core'] = rec['clast_phrase']

                bnr2['clast_weight'] = rec['clast_weight'] #####
                bnr2['trash'] = rec['trash'] #####
                bnr2['core_domain'] = rec['domain'] #####

                yield bnr2


def deprec_filter(key, recs): #фильтрация depricated слов
    ctgs = {}
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0: #словарь депрекейтов
            ctgs[rec['mctgs']] = 1
        else:
            if len(ctgs) > 0 and rec['mctgs'] not in ctgs:
                yield rec


def clarif(key, recs): #уточнение категоризации
    depr_count = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0: #слова, прошедшие через фильтр депрекейтов
            depr_count += 1
        else: #результаты предварительной категоризации
            rec['cover_core_trash'] -= depr_count #"-" - из-за сортировки по убыванию
            yield rec


def only_first(key, recs): #оставляем только первые CTGS_MAX найденных категорий
    bnr = None
    dup = {} #исключение дубликатов категорий
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0: #баннер из исходного набора ztest
            bnr = rec
        elif bnr != None: #баннер из списка найденных и ранжированных
            if rec['mctgs'] not in dup and len(dup) < CTGS_MAX: #максимальное число категорий для баннера
                dup[rec['mctgs']] = 1
                rec['clast_size'] = rec['cluster_size']
                del rec['cluster_size']
                rec['clast_phrase'] = rec['core']
                del rec['core']

                if len(dup) == 1: #первая запись в результатах категоризации
                    ctgs = rec['mctgs_tag'].split('/') #несколько категорий считаются РАЗНЫМИ категориями
                    if rec['mctgs'] not in ctgs: #обучение только НА ОШИБОЧНЫХ
                        ##yield rec
                        pass
                    ##yield rec #обучение НА ВСЕХ результатах категоризации
                yield rec #обучение НА ВСЕХ результатах категоризации

    if len(dup) == 0: #баннер из исходного списка ztest, для которого не было найдено НИ ОДНОГО ЯДРА
        bnr['@table_index'] = 1
        yield bnr


def conv2factor(rec): #выделение ядер с факторами для баннеров и преобразование к формату TrainExact и Test
    yield { "BannerID": rec['bid'], "SemantCore": rec['clast_phrase'], "CoreCategory": rec['mctgs'], "ClusterSize": -rec['clast_size'], "CoreDomain": rec['core_domain'], "CoreTrash": rec['trash'], "CoreWeight": rec['clast_weight'], "CoverCoreTrash": -rec['cover_core_trash'], "CoverCore": -rec['cover_core'], "DomainFind": -rec['domain_find'] }


#--------------------------------------------------------------------------
def only4asses(key, recs): #окончательное формирование данных для асессоров
    flag = 0
    mctgs = []
    cores = []
    for rec in recs:
        if flag == 0:
            flag = 1
        mctgs.append(rec['mctgs'])
        cores.append(rec['clast_phrase'])

    yield { "BannerID": rec['bid'], "Title": rec['title'], "Body": rec['body'], "AutoCategoryNames": rec['mctgs_tag'], "CoreCategories": '/'.join(mctgs), "SemanticCores": '/'.join(cores) }


def cover_stat(key, recs): #определение статистики покрытия
    mctgs = []
    cores = []

    bid = 0
    auto_ctgs = []

    title_norm = ''
    body_norm = ''

    find = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0: #исходный список баннеров
            bid = rec['bid']
            ctgs = rec['mctgs'].split('/') #"родные" категории Каталогии
            for ctg in ctgs:
                pref = re.split(r' _ ', ctg)
                if len(pref) == 2: #есть виртуальный префикс
                    #auto_ctgs.append(pref[1]) #базовая категория
                    auto_ctgs.append(pref[0]) #виртуальный префикс
                else:
                    #auto_ctgs.append(ctg)
                    auto_ctgs.append('Невиртуальная')
        elif bid != 0: #результаты поиска ядер
            title_norm = rec['title_norm'] ###
            body_norm = rec['body_norm'] ###

            ctgs = rec['mctgs_tag'].split('/') #результаты ручной разметки
            category = []
            for ctg in ctgs:
                pref = re.split(r' _ ', ctg)
                if len(pref) == 2: #есть виртуальный префикс
                    #category.append(pref[1]) #базовая категория
                    category.append(pref[0]) #виртуальный префикс
                else:
                    #category.append(ctg)
                    category.append('Невиртуальная')

            mctgs.append(rec['mctgs']) #категория ядра
            cores.append(rec['clast_phrase'])

            if rec['mctgs'] in category: #категория ядра
                find = 1
                break

            for auto_ctg in auto_ctgs:
                pref = re.split(r' _ ', auto_ctg)
                if len(pref) == 2: #есть виртуальный префикс
                    auto = pref[1] #базовая категория
                else:
                    auto = auto_ctg
                if auto in category:
                    find = 1
                    break

    if find == 1: #для баннера определена правильная категория
        yield { "BannerID": rec['bid'], "Title": title_norm, "Body": body_norm, "CategoryNames": rec['mctgs_tag'], "CoreCategories": '/'.join(mctgs), "AutoCategoryNames": '/'.join(auto_ctgs), "SemanticCores": '/'.join(cores) }
    else: #для баннера определена ошибочная категория
        if title_norm != '': #чтобы не учитывать баннеры с ненайденными ядрами
            yield { "BannerID": rec['bid'], "Title": title_norm, "Body": body_norm, "CategoryNames": rec['mctgs_tag'], "CoreCategories": '/'.join(mctgs), "AutoCategoryNames": '/'.join(auto_ctgs), "SemanticCores": '/'.join(cores), "@table_index": 1 }


class add_mctgs(object): #добавление оригинальных AutoCategoryNames и AutoCategoryIDs из Train, и CoreCategoryIDs из словаря ctgs2ids
    def __init__(self, ctgs2ids):
        self.ctgs2ids = ctgs2ids #маппинг CategoryName в CategoryID
    def __call__(self, key, recs):
        bid = 0
        for rec in recs:
            table_index = rec.pop('@table_index')
            if table_index == 0:
                bid = rec['BannerID']
                ctgs = rec['AutoCategoryNames']
                ctgs_id = rec['AutoCategoryIDs']
            else:
                if bid != 0:
                    rec['AutoCategoryNames'] = ctgs
                    rec['AutoCategoryIDs'] = ctgs_id
                else:
                    rec['AutoCategoryIDs'] = '0'

                ids = [] #ID для категорий ядер
                ctgs = rec['CoreCategories'].split('/')
                for ctg in ctgs:
                    if ctg in self.ctgs2ids:
                        ids.append(str(self.ctgs2ids[ctg]))
                    else:
                        ids.append('0')
                rec['CoreCategoryIDs'] = ','.join(ids)

                yield rec
#--------------------------------------------------------------------------


def main():
    #--- 1. Поиск семантических ядер ---
    tab1 = '//tmp/yuryz/ztest_join' #тестовая выборка (см. categ_sem_core.sh)
    tab2 = '//home/catalogia/users/yuryz/tmp/sem_core_clast_size' #словарь семантических ядер (см. read_core_index.py)

    tab3 = '//tmp/yuryz/ztest_join_find' #результаты поиска записей из tab1 в tab2
    tab4 = '//tmp/yuryz/ztest_4deprec' #для поиска в депрекейтах

    #yt.run_reduce(core_find, [tab1, tab2], [tab3, tab4], reduce_by = ['two_word_index'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab3, sort_by=['bid', 'core'])
    #yt.run_sort(tab4, sort_by=['word', 'bid'])

    #--- 2. Фильтрация depricated слов ---
    tab5 = '//home/catalogia/users/yuryz/tmp/deprec_expand'
    tab6 = '//tmp/yuryz/wrd2ctg'

    #yt.run_reduce(deprec_filter, [tab5, tab4], tab6, reduce_by = ['word'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab6, sort_by=['bid', 'core', 'word'])

    #--- 3. Уточнение категоризации ---
    tab7 = '//tmp/yuryz/ztest_join_categ'

    #yt.run_reduce(clarif, [tab6, tab3], tab7, reduce_by = ['bid', 'core'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab7, sort_by=['bid', 'domain_find', 'cover_core_trash', 'cover_core', 'cluster_size'])

    #--- 4. Оставляем только первые записи из списка найденных и ранжированных ---
    tab_src = '//tmp/yuryz/ztest' #см. categ_sem_core.sh
    tab8 = '//home/catalogia/users/yuryz/contest/ztest_join_categ'
    tab_not_found = '//home/catalogia/users/yuryz/contest/bnrs_not_found'

    yt.run_reduce(only_first, [tab_src, tab7], [tab8, tab_not_found], reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))

    #--- *** ЭТИ СТРОЧКИ ТОЛЬКО ДЛЯ АСЕССОРОВ *** ---
    yt.run_sort(tab8, sort_by=['bid', 'domain_find', 'cover_core_trash', 'cover_core', 'clast_size'])

    tab9 = '//home/catalogia/users/yuryz/contest/bnrs_ctgs_true'
    tab10 = '//home/catalogia/users/yuryz/contest/bnrs_ctgs_false'

    ##yt.run_reduce(only4asses, tab8, tab9, reduce_by = ['bid'])
    yt.run_reduce(cover_stat, [tab_src, tab8], [tab9, tab10], reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields")) #ОПРЕДЕЛЕНИЕ СТАТИСТИКИ ПОКРЫТИЯ

    #yt.run_sort(tab9, sort_by=['BannerID', 'Title', 'Body', 'AutoCategoryNames', 'CoreCategories'])

    ##yt.run_sort('//home/catalogia/contest/Train', '//tmp/yuryz/Train', sort_by=['BannerID']) #TRAIN
    ##yt.run_sort('//home/catalogia/contest/TrainExact', '//tmp/yuryz/Train', sort_by=['BannerID']) #TRAINEXACT
    ##yt.run_sort('//home/catalogia/contest/Test', '//tmp/yuryz/Train', sort_by=['BannerID']) #TEST

    tab10 = '//home/catalogia/users/yuryz/contest/data4asses'

    ctgs2ids = {} #маппинг CategoryName в CategoryID
    for rec in yt.read_table('//home/catalogia/categories_tree', raw=False):
        ctgs2ids[rec['Category']] = rec['DirectID']

    #yt.run_reduce(add_mctgs(ctgs2ids), ['//tmp/yuryz/Train', tab9], tab10, reduce_by = ['BannerID'], format=yt.YsonFormat(control_attributes_mode="row_fields"))

    #yt.run_sort(tab10, sort_by=['BannerID', 'Title', 'Body', 'AutoCategoryNames', 'CoreCategories'])
    #--- *** ЭТИ СТРОЧКИ ТОЛЬКО ДЛЯ АСЕССОРОВ *** ---

    ##tab9 = '//home/catalogia/users/yuryz/contest/CoreFactors4TrainExact'
    #tab9 = '//home/catalogia/users/yuryz/contest/CoreFactorsTrain4TrainExact'

    ##tab9 = '//home/catalogia/users/yuryz/contest/CoreFactors4Test'
    #tab9 = '//home/catalogia/users/yuryz/contest/CoreFactorsTrain4Test'

    #yt.run_map(conv2factor, tab8, tab9, format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab9, sort_by=['BannerID', 'SemantCore', 'CoreCategory', 'ClusterSize', 'CoreWeight'])


if __name__ == '__main__':
    main()
