#!/usr/bin/perl -w
#выбор категории по семантическому ядру

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


my %ctg;
open F, "ctg_list";
while (<F>) {
    chomp;
    my ($ctg, $ctg_id) = split /\t/;
    $ctg{$ctg_id} = $ctg;
    $ctg{$ctg} = $ctg_id; #--- для учета депрекейтов ---
}

my %filter;
open F, "word_filter"; #словарь ВСЕХ слов в ядрах Каталогии
while (<F>) {
    chomp;
    $filter{$_} = 1;
}

my %index;
open F, "two_word_index";
my $cnt = 0;
my $size = (stat(F))[7];
while (<F>) {
    progress(tell(F), $size, 'Загрузка словаря two_word_index') if ++$cnt % 5000 == 0;
    chomp;
    my ($pair, $ind1, $ind2) = split /\t/;
    $index{$pair} = "$ind1\t$ind2";
}
print STDERR "\n";

my %core2ctg;
open F, "core_correct"; #корректировочный словарь ядер
while (<F>) {
    chomp;
    my ($core1, $core2, $ctg) = split /\t/;
    my $ctg_id = $ctg{$ctg} ? $ctg{$ctg} : $ctg; #название_категории => ctg_id
    $core2ctg{"$core1\t$core2"} = $ctg_id;
}

my @core;
open F, "core_index_id";
$cnt = 0;
$size = (stat(F))[7];
while (<F>) {
    progress(tell(F), $size, 'Загрузка словаря core_index_id') if ++$cnt % 10000 == 0;
    chomp;
    push @core, $_;
}
print STDERR "\n";

my %deprec;
open F, "deprec_expand"; #учет депрекейтов ( deprec_expand.pl <dict_deprecated_categs_words_ru |LC_ALL=C sort -u >deprec_expand )
$cnt = 0;
$size = (stat(F))[7];
while (<F>) {
    progress(tell(F), $size, 'Загрузка словаря deprec_expand') if ++$cnt % 1000 == 0;
    chomp;
    my ($word, $ctg_name) = split /\t/;
    my $ctg = $ctg{$ctg_name} ? $ctg{$ctg_name} : $ctg_name; #перекодировка имени в ID
    $deprec{$word}{$ctg} = 1; #$ctg может быть равна ДЖОКЕРУ "*"!!!
}
print STDERR "\n";


my $bnr_total = 0; #обработано баннеров
my $bnr_corr = 0; #из них правильно
my $bnr_corr2 = 0; #из них правильно во второй позиции ######################

$cnt = 0;
$size = (stat(STDIN))[7]; #длина файла
while (<STDIN>) { #test
    $bnr_total++;
    progress(tell(STDIN), $size, 'Обработка баннеров') if ++$cnt % 10 == 0;
    chomp;

    my ($bid, $title, $body, $mctgs, $bnr_domain) = split /\t/;

    my $title_pre = $proj->phrase($title)->get_banner_prefiltered_phrase->text; #префильтрация title
    my $title_nrm = $proj->phrase($title_pre)->norm_phr_ordered; #нормализация title с учетом порядка слов

    my $body_pre = $proj->phrase($body)->get_banner_prefiltered_phrase->text; #префильтрация body
    my $body_nrm = $proj->phrase($body_pre)->norm_phr_ordered; #нормализация body с учетом порядка слов

    my %dup;
    my @uniq = grep { !$dup{$_}++ } split / /, "$title_nrm $body_nrm"; #удаление дублей из нормализованного текста

    my @good; #слова баннера, которые МОГУТ входить в какие-либо ядра ("хорошие" слова)
    my %good;
    for my $uniq (@uniq) {
        if ($filter{$uniq}) { #фильтрация слов, не входящих НИ В КАКИЕ семантические ядра
            push @good, $uniq;
            $good{$uniq} = 1;
        }
    }

    my @pair;
    for my $i (0..$#good-1) { #генерация пар слов для поиска семантического ядра
        for my $j ($i+1..$#good) {
            push @pair, "$good[$i] $good[$j]", "$good[$j] $good[$i]";
        }
        push @pair, $good[$i]; #учет ОДНОСЛОВНЫХ ядер
    }
    push @pair, $good[$#good]; #учет ОДНОСЛОВНЫХ ядер

    my @sem_core;
    for my $pair (@pair) { #поиск семантических ядер
        next unless $pair;
        if ($index{$pair}) {
            my @ind = split /\t/, $index{$pair};
            for my $i ($ind[0]..$ind[1]) { #средняя длина цепочки перебора примерно 11-12 ядер
                my ($core, $ctg, $size, $trash, $domain) = split /\t/, $core[$i];
                my @word = split / /, $core; #слова найденного ядра

                my $flag = 0;
                for my $j (2..$#word) { # 2 - т.к. слова ядра 0 и 1 - уже совпадают с $pair
                    unless ($good{$word[$j]}) { #"чужое" слово - ядро не подходит
                        $flag = 1;
                        last;
                    }
                }
                if ($flag == 0) {
                    my %word_trash;
                    $word_trash{$_} = 1 for @uniq;
                    for my $word (@word) { #слова найденного ядра
                        delete $word_trash{$word}; #удаляем слова, входящие в ядро
                    }

                    my %trash; #слова, которые МОГУТ быть в тексте баннера, но их НЕ ДОЛЖНО быть в ядре (см. tf_idf_4.py)
                    $trash{$_} = 1 for split / /, $trash;
                    my $count_trash = 0; #счетчик слов баннера, не вошедших в ядро, но вошедших в $trash или в deprec_expand
                    for my $word_trash (keys %word_trash) {
                        $count_trash++ if $trash{$word_trash} || $deprec{$word_trash} && !$deprec{$word_trash}{$ctg};
                    }

                    push @sem_core, "$core[$i]\t$count_trash";
                }
            }
        }
    }

    if (@sem_core) {
        #--- РАНЖИРОВАНИЕ РЕЗУЛЬТАТОВ ---
        my %cores; #подготовка данных для ранжирования найденных категорий
        for my $i (0..$#sem_core) { #массив ВСЕХ найденных ядер, категории которых необходимо ранжировать
            #my ($core, $ctg, $size, $trash, $domain, $count_trash) = split /\t/, $sem_core[$i];
            my ($core, $ctg, $size, $trash, $domain, $weight_max, $entropy, $count_trash) = split /\t/, $sem_core[$i];

            $cores{$core}{CTG} = $ctg;
            $cores{$core}{SIZE} = $size;

            my $len = scalar (split / /, $core);
            $cores{$core}{LEN} = $len;
            $cores{$core}{COVER} = $len + $count_trash;

            my %domain; #список доменов из ядра
            $domain{$_} = 1 for split / /, $domain;
            $cores{$core}{DOMAIN} = $domain{$bnr_domain} ? $bnr_domain : "";

            $cores{$core}{WEIGH} = $weight_max;
            $cores{$core}{ENT} = $entropy;
        }

        #--- РАНЖИРОВАНИЕ И ПЕЧАТЬ РЕЗУЛЬТАТОВ ---
        my @cores = sort { $cores{$b}{DOMAIN} cmp $cores{$a}{DOMAIN} || $cores{$b}{COVER} <=> $cores{$a}{COVER} || $cores{$b}{LEN} <=> $cores{$a}{LEN} || $cores{$b}{SIZE} <=> $cores{$a}{SIZE} } keys %cores; #по убыванию величины покрытия, иначе - по размеру ядра, иначе - по размеру кластера
        if (@cores > 1) {
            if ($core2ctg{"$cores[0]\t$cores[1]"}) { #корректировочный словарь ядер
                $cores{$cores[0]}{CTG} = $core2ctg{"$cores[0]\t$cores[1]"};
            }
            if ($cores{$cores[1]}{LEN} - $cores{$cores[0]}{LEN} >= 4) { #перестановка местами первых двух кандидатов (4 - установлена экспериментально)
                ($cores[0], $cores[1]) = ($cores[1], $cores[0]);
            }
            if ($cores{$cores[1]}{SIZE} / $cores{$cores[0]}{SIZE} > 10 && ($cores{$cores[1]}{ENT} == 0 || $cores{$cores[0]}{ENT} / $cores{$cores[1]}{ENT} > 10 )) { #перестановка местами первых двух кандидатов (4 - установлена экспериментально)
                ($cores[0], $cores[1]) = ($cores[1], $cores[0]); ############
            }
        }

        my $ctg_name = $ctg{$cores{$cores[0]}{CTG}} ? $ctg{$cores{$cores[0]}{CTG}} : $cores{$cores[0]}{CTG}; #ctg_id => название_категории
        if ($ctg_name eq $mctgs) { #первая по рангу категория является ПРАВИЛЬНОЙ
            $bnr_corr++;
        } else {
            my %dup;
            my @cores_res;
            for my $i (0..$#cores) {
                $ctg_name = $ctg{$cores{$cores[$i]}{CTG}} ? $ctg{$cores{$cores[$i]}{CTG}} : $cores{$cores[$i]}{CTG}; #ctg_id => название_категории
                unless ($dup{$ctg_name}) { #исключаем дубли категорий
                    $dup{$ctg_name} = 1;
                    my $core = "$cores[$i]\t$ctg_name\t$cores{$cores[$i]}{COVER}\t$cores{$cores[$i]}{LEN}\t$cores{$cores[$i]}{SIZE}\t$cores{$cores[$i]}{DOMAIN}\t$cores{$cores[$i]}{WEIGH}\t$cores{$cores[$i]}{ENT}";
                    push @cores_res, $core;
                    last if $i+1 >= 2; #*** 2 - сколько ядер выводить
                }
            }

            #--- печать результатов ---
            print "$bid\t$title\t$body\t$mctgs\t$bnr_domain\n";
            print "[ @good ]\n";
            for my $i (0..$#cores_res) {
                my ($core, $ctg_name, $cover, $len, $size, $domain) = split /\t/, $cores_res[$i];
                if ($ctg_name eq $mctgs && $i == 1) { # *** ВТОРАЯ ПОЗИЦИЯ ***
                    $bnr_corr2++;
                    print "*";
                    
                }
                print "$cores_res[$i]\n";
            }
            print "\n";
        }
    }
}

print STDERR "\n";
print STDERR "TOTAL=$bnr_total\n";
print STDERR "CORRECT=$bnr_corr\n";
print STDERR "CORRECT2=$bnr_corr2\n"; ############
print STDERR "OK\n";


#--- ProgressBar ---
sub progress {
    my ($count, $total, $status) = @_;
    my $bar_len = 50;
    my $filled_len = int(sprintf("%.f", $bar_len * $count / $total));

    my $percents = sprintf "%.1f", 100.0 * $count / $total;
    my $bar = ('■' x $filled_len).('-' x ($bar_len - $filled_len));

    printf STDERR "[%s] %s%s %s\r", $bar, $percents, '%', $status;
    STDERR->flush();
}
