#!/usr/bin/python
# -*- coding: utf-8 -*-

#преобразование ЭТАЛОННЫХ обучающей и тестовой выборок к окончательному формату

import sys
import re
import yt.wrapper as yt


def convert(key, recs): #преобразование форматов таблиц
    bid = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            rec2 = rec
            bid = rec2['bid']
        elif bid != 0:
            yield { "bid": rec2['bid'], "title": rec2['title'], "body": rec2['body'], "mctgs": rec2['mctgs'], "domain": rec2['domain'], "href": rec['href'], "phrases": rec['phrases'] }


def main():
    #tab1 = '//home/catalogia/users/yuryz/contest/test'
    tab1 = '//home/catalogia/users/yuryz/contest/train'
    tab2 = '//home/catalogia/banners_extended'

    #tab3 = '//home/catalogia/users/yuryz/contest/cts_test'
    tab3 = '//home/catalogia/users/yuryz/contest/cts_train'

    yt.run_reduce(convert, [tab1, tab2], tab3, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab3, sort_by=['bid'])

    print >> sys.stderr, yt.row_count(tab1)
    print >> sys.stderr, yt.row_count(tab2)
    print >> sys.stderr, yt.row_count(tab3)


if __name__ == '__main__':
    main()
