#!/usr/bin/python
# -*- coding: utf-8 -*-

#преобразование ПОЛНОЙ обучающей выборки к окончательному формату

import sys
import re
import yt.wrapper as yt


def del_dup(key, recs): #удаление дублей
    yield recs.next()


def select(key, recs): #выбор полных вариантов обучающих выборок
    mctgs = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            mctgs = rec['mctgs']
        elif mctgs != '':
            yield { "bid": rec['bid'], "title": rec['title'], "body": rec['body'], "mctgs": rec['mctgs'], "domain": rec['domain'] }


def convert(key, recs): #преобразование форматов таблиц
    bid = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            rec2 = rec
            bid = rec2['bid']
        elif bid != 0:
            yield { "bid": rec2['bid'], "title": rec2['title'], "body": rec2['body'], "mctgs": rec2['mctgs'], "domain": rec2['domain'], "href": rec['href'], "phrases": rec['phrases'] }


def exclude(key, recs): #исключение тестовых баннеров из полной обучающей выборки
    bid = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            bid = rec['bid']
        elif bid == 0: #НЕ тестовый баннер
            yield rec


def main():
    tab1 = '//home/catalogia/users/yuryz/contest/ctg_count'
    tab2 = '//home/catalogia/users/yuryz/ctg_corr/core_title_dist_size'
    tab3 = '//tmp/yuryz/cts_train_full'

    #=== ВРЕМЕННО ===
    #yt.run_sort(tab2, '//tmp/yuryz/t1', sort_by=['title_norm', 'body_norm', 'bid'])
    #yt.run_reduce(del_dup, '//tmp/yuryz/t1', '//tmp/yuryz/t2', reduce_by = ['title_norm', 'body_norm'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort('//tmp/yuryz/t2', sort_by=['mctgs', 'clast_size', 'clast_phrase', 'dist', 'bid'])
    tab2 = '//tmp/yuryz/t2'
    #=== ВРЕМЕННО ===

    #yt.run_reduce(select, [tab1, tab2], tab3, reduce_by = ['mctgs'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab3, sort_by=['bid'])

    tab4 = '//home/catalogia/banners_extended'
    tab5 = '//tmp/yuryz/cts_train_full_2'

    #yt.run_reduce(convert, [tab3, tab4], tab5, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab5, sort_by=['bid'])
    yt.run_sort(tab5, '//home/catalogia/users/yuryz/contest/bnrs4contest', sort_by=['bid']) #=== ВРЕМЕННО ===

    tab6 = '//home/catalogia/users/yuryz/contest/cts_test'
    tab7 = '//home/catalogia/users/yuryz/contest/cts_train_full'


    #yt.run_reduce(exclude, [tab6, tab5], tab7, reduce_by = ['bid'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab7, sort_by=['bid'])

    """
    print >> sys.stderr, yt.row_count(tab1)
    print >> sys.stderr, yt.row_count(tab2)
    print >> sys.stderr, yt.row_count(tab3)

    print >> sys.stderr, yt.row_count(tab4)
    print >> sys.stderr, yt.row_count(tab5)

    print >> sys.stderr, yt.row_count(tab6)
    print >> sys.stderr, yt.row_count(tab7)
    """


if __name__ == '__main__':
    main()
