#!/usr/bin/python
# -*- coding: utf-8 -*-

#формирование baseline

import sys
import re
import random
import yt.wrapper as yt

from urlparse import urlparse

class baseline(object): #выбор баннеров
    def __init__(self, ctgs):
        self.ctgs = ctgs #словарь категорий эталона

    def __call__(self, rec):
        size = len(self.ctgs)
        if random.random() < 0.3:
            i = random.randint(0, size-1)
            rec['mctgs'] = self.ctgs[i] #случайная замена категории
        yield rec


def main():
    tab1 = '//home/catalogia/users/yuryz/contest/cts_test'
    tab2 = '//home/catalogia/users/yuryz/contest/cts_baseline'

    ctgs = []

    f = open('ctgs_etalon', 'r') #категории, входящие в эталон
    for line in f:
        ctg = line.rstrip('\n')
        ctgs.append(ctg)

    yt.run_map(baseline(ctgs), tab1, tab2)
    yt.run_sort(tab2, sort_by=['bid', 'body', 'mctgs'])

    print >> sys.stderr, yt.row_count(tab1)
    print >> sys.stderr, yt.row_count(tab2)


if __name__ == '__main__':
    main()
