#!/usr/bin/perl -w
#конвертирование top_corr в формат для построения ядер

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

open F, "bnrs_no_ctg"; #(см. get_bnrs_no_ctg.py)
my %bnr2yql;
while (<F>) {
    chomp;
    my ($bid, $yql) = split /\t/;
    next unless $bid =~ /^\./; #если еще непроверенные (см. get_bnrs_no_ctg.py)
    $bid =~ s/^\.//;
    $bnr2yql{$bid} = $yql;
}

=z
while (<STDIN>) { #top_corr
    chomp;
    my ($bid, $title, $body, $yql, $show, $mctgs) = split /\t/;

    if ($bnr2yql{$bid}) {
        print "$bnr2yql{$bid}\t$bid\t$title\t$body\t$mctgs\n";
    }
}
=cut

while (<STDIN>) { #bnrs_ctg_corr
    chomp;
    my ($yql, $bid, $title, $body, $bnorm, $mctgs, $url) = split /\t/;

    print "$yql\t$bid\t$title\t$body\t$mctgs\n";
}
