#!/usr/bin/python
# -*- coding: utf-8 -*-

#конвертирование //home/catalogia/contest/Train и //home/catalogia/contest/TrainExact в формат //home/catalogia/users/yuryz/tmp/bnrs_norm

import sys
import re
import yt.wrapper as yt


def conv_train(rec):
    ctgs = rec['AutoCategoryNames'].split('/') #несколько категорий считаются РАЗНЫМИ категориями
    for ctg in ctgs:
        yield { "bid": rec['BannerID'], "title": rec['Title'], "title_norm": rec['NormTitle'], "body": rec['Body'], "body_norm": rec['NormBody'], "domain": rec['Domain'], "mctgs": ctg, "phrases": rec['Phrases'], "phrases_norm": "", "title_extension": rec['TitleExtension'],  "title_extension_norm": rec['NormTitleExtension'] }


def conv_exact(rec):
    ctgs = rec['CategoryNames'].split('/') #несколько категорий считаются РАЗНЫМИ категориями
    for ctg in ctgs:
        yield { "bid": rec['BannerID'], "title": rec['Title'], "title_norm": rec['NormTitle'], "body": rec['Body'], "body_norm": rec['NormBody'], "domain": rec['Domain'], "mctgs": ctg, "phrases": rec['Phrases'], "phrases_norm": "", "title_extension": rec['TitleExtension'],  "title_extension_norm": rec['NormTitleExtension'] }


class conv_train_virt(object): #объединение виртуальных категорий в одну базовую
    def __init__(self, ctgs2ids):
        self.ctgs2ids = ctgs2ids #маппинг CategoryName в CategoryID
    def __call__(self, rec):
        ctgs = rec['AutoCategoryNames'].split('/') #несколько категорий считаются РАЗНЫМИ категориями
        dup = {}
        for ctg in ctgs:
            if ctg not in self.ctgs2ids: #оставляем только актуальные категории
                yield { "bid": rec['BannerID'], "title": rec['Title'], "title_norm": rec['NormTitle'], "body": rec['Body'], "body_norm": rec['NormBody'], "domain": rec['Domain'], "mctgs": ctg, "phrases": rec['Phrases'], "phrases_norm": "", "title_extension": rec['TitleExtension'],  "title_extension_norm": rec['NormTitleExtension'], "@table_index": 1 }
                continue

            pref = re.split(r' _ ', ctg)
            if len(pref) == 2: #есть виртуальный префикс
                category = pref[1]
            else:
                category = ctg

            if category not in dup:
                dup[category] = 1
                yield { "bid": rec['BannerID'], "title": rec['Title'], "title_norm": rec['NormTitle'], "body": rec['Body'], "body_norm": rec['NormBody'], "domain": rec['Domain'], "mctgs": category, "phrases": rec['Phrases'], "phrases_norm": "", "title_extension": rec['TitleExtension'],  "title_extension_norm": rec['NormTitleExtension'] }


class conv_ctg2virt_pref(object): #формирование отдельных категорий, являющихся виртуальными префиксами
    def __init__(self, ctgs2ids):
        self.ctgs2ids = ctgs2ids #маппинг CategoryName в CategoryID
    def __call__(self, rec):
        ctgs = rec['AutoCategoryNames'].split('/') #несколько категорий считаются РАЗНЫМИ категориями
        dup = {}
        for ctg in ctgs:
            if ctg not in self.ctgs2ids: #оставляем только актуальные категории
                yield { "bid": rec['BannerID'], "title": rec['Title'], "title_norm": rec['NormTitle'], "body": rec['Body'], "body_norm": rec['NormBody'], "domain": rec['Domain'], "mctgs": ctg, "phrases": rec['Phrases'], "phrases_norm": "", "title_extension": rec['TitleExtension'],  "title_extension_norm": rec['NormTitleExtension'], "@table_index": 1 }
                continue

            pref = re.split(r' _ ', ctg)
            if len(pref) == 2: #есть виртуальный префикс
                category = pref[0] #новая категория - "виртуальный_префикс"
            else:
                category = "Невиртуальная" #новая категория - "Невиртуальная"

            if category not in dup:
                dup[category] = 1
                yield { "bid": rec['BannerID'], "title": rec['Title'], "title_norm": rec['NormTitle'], "body": rec['Body'], "body_norm": rec['NormBody'], "domain": rec['Domain'], "mctgs": category, "phrases": rec['Phrases'], "phrases_norm": "", "title_extension": rec['TitleExtension'],  "title_extension_norm": rec['NormTitleExtension'] }


def main():
    tab1 = '//home/catalogia/contest/Train'
    tab2 = '//tmp/yuryz/bnrs_norm'

    ctgs2ids = {} #маппинг CategoryName в CategoryID
    for rec in yt.read_table('//home/catalogia/categories_tree', raw=False):
        ctgs2ids[rec['Category']] = rec['DirectID']

    ##yt.run_map(conv_train, tab1, tab2)
    ##yt.run_map(conv_train_virt(ctgs2ids), tab1, [tab2, '//tmp/yuryz/ctgs_not_found'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_map(conv_ctg2virt_pref(ctgs2ids), tab1, [tab2, '//tmp/yuryz/ctgs_not_found'], format=yt.YsonFormat(control_attributes_mode="row_fields"))

    tab3 = '//home/catalogia/contest/TrainExact'

    #yt.run_map(conv_exact, tab3, yt.TablePath(tab2, append=True))

    tab4 = '//home/catalogia/users/yuryz/tmp/bnrs_norm'

    yt.run_sort(tab2, tab4, sort_by=['bid', 'mctgs']) #сортировка ОБЯЗАТЕЛЬНА


if __name__ == '__main__':
    main()
