#!/usr/bin/python
# -*- coding: utf-8 -*-

#вычисление расстояния между core+trash и title+body

import sys
import re
import math

import yt.wrapper as yt


def core_title_dist(rec): #вычисление расстояния между core+trash и title+body
    pos_sem = {} #словарь СЕМАНТИЧЕСКИХ позиций
    cnt = 0
    for wrd in rec['clast_phrase'].split():
        num = (cnt + 1.0) / 2 #нумерация с шагом = 0.5
        cnt += 1
        pos_sem[wrd] = num
    for wrd in rec['trash'].split():
        cnt += 1
        num = cnt #нумерация с шагом = 1
        pos_sem[wrd] = num

    pos_sint = {} #словарь СИНТАКТИЧЕСКИХ позиций
    cnt = 0
    for wrd in rec['title_norm'].split():
        if wrd in pos_sem and not wrd in pos_sint: #число слов д.б. одинаковым в обоих словарях
            num = (cnt + 1.0) / 2 #нумерация с шагом = 0.5
            cnt += 1
            pos_sint[wrd] = num
    for wrd in rec['body_norm'].split():
        if wrd in pos_sem and not wrd in pos_sint: #число слов д.б. одинаковым в обоих словарях
            cnt += 1
            num = cnt #нумерация с шагом = 1
            pos_sint[wrd] = num

    dist = 0 #расстояние между core+trash и title+body
    cnt = 0
    for wrd in pos_sem:
        if wrd in pos_sint:
            dist += math.fabs(pos_sem[wrd] - pos_sint[wrd])
            cnt += 1
    if cnt > 0:
        dist = '%.2f' % (dist / cnt)
    else:
        dist = 100

    rec['dist'] = float(dist)
    yield rec


def main():
    #tab1 = '//home/catalogia/users/yuryz/tmp/bnrs_norm_sense_disamb'
    tab1 = '//home/catalogia/users/yuryz/tmp/bnrs_norm_sense_disamb_src'
    tab2 = '//home/catalogia/users/yuryz/ctg_corr/core_title_dist'

    yt.run_map(core_title_dist, tab1, tab2)
    yt.run_sort(tab2, sort_by=['dist', 'bid']) #ЭТАЛОНЫ

    tab3 = '//home/catalogia/users/yuryz/ctg_corr/bid_dist'

    yt.run_sort(tab2, tab3, sort_by=['bid']) #ДЛЯ ОБНАРУЖЕНИЯ И ИСПРАВЛЕНИЯ ОШИБОК КАТЕГОРИЗАЦИИ (см. ctg_detect.py)

    print >> sys.stderr, yt.row_count(tab1)
    print >> sys.stderr, yt.row_count(tab2)
    print >> sys.stderr, yt.row_count(tab3)


if __name__ == '__main__':
    main()
