#!/usr/bin/python
# -*- coding: utf-8 -*-

#автоматическое обнаружение и исправление ошибок категориации

import sys
import re
import math

import yt.wrapper as yt


NEIGHBORS = 2 #число соседей сверху и снизу
COVER_MIN = 2 #MIN порог пересечения среднего баннера с соседями

#--- progress bar ---
def progress(count, total, status=''):
    bar_len = 60
    filled_len = int(round(bar_len * count / float(total)))

    percents = round(100.0 * count / float(total), 1)
    bar = '■' * filled_len + '-' * (bar_len - filled_len)

    sys.stderr.write('[%s] %s%s ...%s\r' % (bar, percents, '%', status))
    sys.stderr.flush()


def main():
    tab = '//home/catalogia/users/yuryz/ctg_corr/bid_dist' #bid, body, clast_phrase, mctgs, title, trash, dist, title_norm, body_norm

    recs = yt.read_table(tab, raw=False) #*** итератор ***

    size = 2 * NEIGHBORS + 1 #размер окон для анализа

    #окна для анализа
    mctgs = []
    core = []
    bnr = []
    dist = []

    cnt = 0
    while 1 : #--- первичное заполнение окна ---
        rec = recs.next()
        cnt += 1
        if cnt > size:
            break
        mctgs.append(rec['mctgs'])
        core.append(rec['clast_phrase'] + '\t' + rec['trash'])
        bnr.append(str(rec['bid']) + '\t' + rec['title'] + '\t' + rec['body'])
        dist.append(rec['dist'])

    steps = yt.row_count(tab)
    step = cnt
    while 1: #--- анализ данных в окне ---
        same = set() #проверка одинаковости категорий соседей сверху и снизу
        avg = (size - 1) / 2 #средний элемент окна
        for i in range(size):
            if i != avg: #средний элемент пропускаем
                same.add(mctgs[i])

        if len(same) == 1: #ВСЕ соседи имеют одинаковые категории
            if mctgs[avg] != mctgs[0]: #средняя категория отличается от соседей
                core_neigh = set() #слова из ядер и трэшей соседей
                word_first = set() #первые слова ядер из соседей
                for i in range(size):
                    if i != avg:
                        L = core[i].split('\t') #core + trash соседа
                        sense = L[0].split() + L[1].split() #все слова из ядра и треша
                        core_neigh |= set(sense)
                        word_first.add(sense[0])

                L = core[avg].split('\t') #core + trash баннера в СЕРЕДИНЕ окна (с "подозрительной" категорией)
                sense = L[0].split() + L[1].split() #все слова из ядра и треша
                cover = 0 #покрытие - число общих слов с соседями
                for word in sense:
                    if word in core_neigh:
                        cover += 1
                word_first_avg = sense[0] #первое слово из ядра СРЕДНЕГО баннера

                #if cover > COVER_MIN and not word_first_avg in word_first: #ОБНАРУЖЕНА ошибка категоризации
                if cover > COVER_MIN: #ПОДОЗРЕНИЕ на ошибку категоризации
                    T = list(word_first) #основные темы (первые слова) соседей
                    T.sort()
                    print 'ТЕМЫ: ' + ', '.join(T)

                    for i in range(size): #печать результатов обнаружения ошибки
                        B = bnr[i].split('\t') #0 - bid, 1 - title, 2 - body
                        if i != avg:
                            print str(dist[i]) + '\t' + mctgs[i] + '\t( ' + core[i] + ' )\t' + bnr[i] #B[0]
                        else:
                            print str(dist[i]) + '\t' + mctgs[i] + '\t( ' + core[i] + ' )\t[ ' + str(cover) + ' ]\t' + bnr[i] #B[0]
                    print '--'

        #--- сдвигаем окно на одну запись вверх ---
        mctgs.pop(0)
        core.pop(0)
        bnr.pop(0)
        dist.pop(0)

        step += 1
        if step % 10000 == 0:
            #------------------------------------------------------------
            progress(step, steps, status = 'Обнаружение плохих категорий')
            #-------------------------------------------------------------

        try:
            rec = recs.next()
        except StopIteration:
            break

        mctgs.append(rec['mctgs'])
        core.append(rec['clast_phrase'] + '\t' + rec['trash'])
        bnr.append(str(rec['bid']) + '\t' + rec['title'] + '\t' + rec['body'])
        dist.append(rec['dist'])

    print >>sys.stderr #для ProgressBar


if __name__ == '__main__':
    main()
