#!/usr/bin/perl -w
#выявление дисбаланса категорий

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


while(<STDIN>) { #ctg_list
    chomp;
    my ($ctg, $cid) = split /\t/; #категория, для которой необходимо определить потомков

    my @childs = ctgs_child($ctg); #дети (виртуальные тоже входят)

    my $sum = 0; #общее число внуков
    if (@childs > 0) { #бездетные категории не рассматриваем
        #print "$ctg\n";

        my %childs; #подсчет числа внуков для каждого НЕВИРТУАЛЬНОГО ребенка
        for my $child (@childs) { #список детей
            next if $child =~ / _ /; #виртуальные дети сами детей иметь не могут :)
            #print "\t$child\n";

            my @grands = ctgs_child($child); #внуки (виртуальные тоже входят)
            $childs{$child} = @grands+0;
            $sum += @grands+0;
            for my $grand (@grands) { #список внуков
                #print "\t\t$grand\n";
            }
        }

        if ($sum > 0) { #внуки ДОЛЖНЫ быть
            my $top_childs = int(0.2 * scalar(keys %childs) + 0.5); #размер топа по Парето (0.2 = 20%)

            my $rate = 0; #накопленная доля внуков
            my $count = 0;
            for my $child (sort { $childs{$b} <=> $childs{$a} || $a cmp $b } keys %childs) {
                last if ++$count > $top_childs; #определяем долю внуков у "элиты"
                $rate += $childs{$child};
                my $fract = $sum ? sprintf("%.2f", $rate / $sum) : 0;
                if ($fract > 0.80) { #накопленная доля внуков у "элиты" по Парето
                    $count = -1; #признак для печати
                }
            }

            if ($count == -1) {
                print "$ctg\n";
                $rate = 0; #накопленная доля внуков
                for my $child (sort { $childs{$b} <=> $childs{$a} || $a cmp $b } keys %childs) {
                    $rate += $childs{$child};
                    my $fract = $sum ? sprintf("%.2f",$rate/$sum) : 0;
                    #print "\t$child\t".$childs{$child}."\t$fract\n";
                    print "\t$child\t".$childs{$child}."\n";
                }
            }
        }
    }
}


#--- получение списка дочерних категорий ---
sub ctgs_child {
    my ($ctg) = @_;

    my @ctgs = ();
    for ($proj->categs_tree->get_minicateg_children($ctg)) {
        push @ctgs, $_;
    }
    return @ctgs;
}


#--- получение ПОЛНОГО списка дочерних категорий (включая внуков, правнуков и т.д.) ---
sub ctgs_nested {
    my ($ctg) = @_;

    my @ctgs = ();
    my @bfs_queue = ($ctg);
    while (@bfs_queue) {
        my $root_category = shift(@bfs_queue);
        for ($proj->categs_tree->get_minicateg_children($root_category)) {
            push @ctgs, $_;
            push @bfs_queue, $_;
        }
    }
    return @ctgs;
}
