#!/usr/bin/perl -w
#поиск подобия в именах категорий Каталогии

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


$| = 1; #отключение буферизации

my %ctg;
open F, "ctg_list";
while (<F>) { #ctg_list
    chomp;
    my ($ctg, $ctg_id) = split /\t/;
    my $tmp = $ctg;
    #$tmp =~ s/[-_]/ /g;
    $tmp =~ s/[_]/ /g;
    my $ctg_norm = $proj->phrase($tmp)->norm_phr;
    $ctg{$ctg} = $ctg_norm;
    
    #$ctg{$ctg} = lc($ctg); #используем словоформы, а не леммы
    #print "$ctg\t$ctg_norm\n";
}

my @ctgs = sort keys %ctg;

for my $i (0..$#ctgs-1) {
    #next if $ctgs[$i] =~ /^[^_]+? _ /; #виртуалки не обрабатываем

    my $vprefI = ""; #виртуальный префикс I
    my $vpostI = $ctgs[$i]; #виртуальный постфикс I
    if ($ctgs[$i] =~ /^([^_]+? _ )(.+?)$/) {
        $vprefI = $1;
        $vpostI = $2;
    }

    my $ancI = ancestors_add($ctgs[$i]); #полная ветвь категории до корня
    my @ancI = split m{/}, $ancI;

    my %wrdsI;
    my @wrdsI = split / /, $ctg{$ctgs[$i]}; #нормализованный список слов из названия категории
    $wrdsI{$_} = 1 for @wrdsI;

    for my $j ($i+1..$#ctgs) {
        #next if $ctgs[$j] =~ /^[^_]+? _ /; #виртуалки не обрабатываем

        my $vprefJ = ""; #виртуальный префикс J
        my $vpostJ = $ctgs[$j]; #виртуальный постфикс J
        if ($ctgs[$j] =~ /^([^_]+? _ )(.+?)$/) {
            $vprefJ = $1;
            $vpostJ = $2;
        }

        next if $vprefI && $vprefJ && ($vprefI eq $vprefJ || $vpostI eq $vpostJ); ###

        my $ancJ = ancestors_add($ctgs[$j]); #полная ветвь категории до корня
        my @ancJ = split m{/}, $ancJ;

        my %wrdsJ;
        my @wrdsJ = split / /, $ctg{$ctgs[$j]}; #нормализованный список слов из названия категории
        $wrdsJ{$_} = 1 for @wrdsJ;

        my $flagI = 0;
        for my $wrd (@wrdsJ) {
            unless ($wrdsI{$wrd}) {
                $flagI = 1;
                last;
            }
        }

        if ($flagI == 0) { #категория J совпадает по названию с категорией I или целиком входит в нее
            next unless $ctgs[$i] =~ / / && $ctgs[$j] =~ / /; #названия категорий НЕ должны быть однословными
            next if $ctgs[$i] =~ /^[^_]+? _ $ctgs[$j]$/i || $ctgs[$j] =~ /^[^_]+? _ $ctgs[$i]$/i; #категория I не должна быть виртуальной для категории J и наоборот
            #next if $ancI =~ m{$ancJ}i || $ancJ =~ m{$ancI}i; #одна ветвь не должна полностью входить в другую

            #--- совпадение ---
            my $flagJ = 0;
            for my $wrd (@wrdsI) {
                unless ($wrdsJ{$wrd}) {
                    $flagJ = 1;
                    last;
                }
            }

            if ($flagJ == 0) { #совпадение ($flagI == 0 && $flagJ == 0)
                print "0\t$ctgs[$i]\t$ctgs[$j]\n"; #совпадение
                #print "$ancI\n";
                #print "$ancJ\n";
                #print "--\n";
            } else {
                next if $ancI =~ m{$ancJ}i || $ancJ =~ m{$ancI}i; #одна ветвь не должна полностью входить в другую
                if ($vprefI && $vprefJ || !$vprefI && !$vprefJ) {
                    print "1\t$ctgs[$i]\t$ctgs[$j]\n"; #вхождение
                    #print "$ancI\n";
                    #print "$ancJ\n";
                    #print "--\n";
                }
            }
        }
    }
}


#--- добавление предков для категории ---
sub ancestors_add {
    my ($categ) = @_;

    my @ancestors; #все предки категории
    my $ancestor = $categ;
    while ($ancestor = $proj->categs_tree->get_minicateg_parent($ancestor)) {
        push @ancestors, $ancestor;
    }

    if (@ancestors > 0) {
        return join("/", reverse @ancestors)."/$categ";
    } else {
        return $categ;
    }
}
