#!/usr/bin/python
# -*- coding: utf-8 -*-

#поиск ближайших родственников для категорий

import sys
import re
import yt.wrapper as yt


def ctg_relative(key, recs): #поиск ближаших родственников
    max_sim = 0
    num_relat = 0
    relat = []
    count = 0
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            max_sim = rec['max_sim']
            num_relat = rec['num_relat']
        else:
            relat.append(rec['ctg2'])
            count += 1
            if count >= num_relat + int(0.3 * num_relat) + 1: break #30% на компенсацию возможной ошибки в тематических семантиках

    if max_sim > 0:
        yield { "ctg1": key['ctg1'], "max_sim": max_sim, "num_relat": num_relat, "relatives": '\t'.join(relat) }


def main():
    tab1 = '//home/catalogia/users/yuryz/compare/ctgs_relativ'
    tab2 = '//home/catalogia/users/yuryz/compare/ctg_proxim'
    tab3 = '//home/catalogia/users/yuryz/compare/ctgs_prox_rel' #категория с MAX близостью и ближайшими родственниками

    yt.run_reduce(ctg_relative, [tab1, tab2], tab3, reduce_by = ['ctg1'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    yt.run_sort(tab3, sort_by=['ctg1'])

    for rec in yt.read_table(tab3, raw=False):
        print rec['ctg1'] + '\t' + str(rec['max_sim']) + '\t' + str(rec['num_relat']) + '\t' + rec['relatives']


if __name__ == '__main__':
    main()
