#!/usr/bin/python
# -*- coding: utf-8 -*-

#печать пар семантически наиболее близких категорий, расположенных наиболее далеко на дереве Каталогии

import sys
import re
import yt.wrapper as yt


def ctgs_pair(key, recs):
    ctg1 = ''
    for rec in recs:
        table_index = rec.pop('@table_index')
        if table_index == 0:
            ctg1 = key['ctg1']
            type = rec['type']
        elif ctg1 != '':
            rec['type'] = type
            yield rec


def main():
    tab1 = '//tmp/yuryz/ctgs_pair'
    tab2 = '//tmp/yuryz/ctg_proxim'
    tab3 = '//tmp/yuryz/ctgs_pair_sim' #пары категорий с семантической близостью

    #yt.run_reduce(ctgs_pair, [tab1, tab2], tab3, reduce_by = ['ctg1', 'ctg2'], format=yt.YsonFormat(control_attributes_mode="row_fields"))
    #yt.run_sort(tab3, sort_by=['ctg1', 'type'])

    for rec in yt.read_table(tab3, raw=False):
        #proxim = '%.18f' % (-rec['proxim'])
        proxim = '{:.18f}'.format(-rec['proxim'])
        #print rec['ctg1'] + '\t' + rec['ctg2'] + '\t' + str(-rec['proxim']) + '\t' + str(rec['type'])
        print rec['ctg1'] + '\t' + rec['ctg2'] + '\t' + str(proxim) + '\t' + str(rec['type'])


if __name__ == '__main__':
    main()
