#!/usr/bin/perl -w
#печать дерева ОБЕИХ (если блок состоит из 2-х записей) категорий с категориями ядра

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


while (my $r1 = <STDIN>) { #ztest_private_ctg (каждый блок состоит из 2-х (редко из 1-й) записей)
    chomp $r1;
    my ($bid1, $title1, $body1, $ctg_good1, $domain1, $ctg_bad1, $core1) = split /\t/, $r1; #первая запись блока

    L:my $r2 = <STDIN>;
    last unless $r2; #конец файла
    chomp $r2;
    my ($bid2, $title2, $body2, $ctg_good2, $domain2, $ctg_bad2, $core2) = split /\t/, $r2; #вторая запись блока
    if ($bid1 ne $bid2) {
        # --- блок состоит из ОДНОЙ записи ---
        $r1 = $r2;
        ($bid1, $title1, $body1, $ctg_good1, $domain1, $ctg_bad1, $core1) = split /\t/, $r1; #первая запись блока
        goto L;
    }

    # --- блок состоит из ДВУХ записей ---
    my $ctgs = $ctg_bad1; #ctgs_private_core (категории ядра)
    my @ctgs = split m{/}, $ctgs; #несколько категорий
    my @anc1;
    push @anc1, ancestors_add($_) for @ctgs;

    $ctgs = $ctg_bad2; #ctgs_private_core (категории ядра)
    @ctgs = split m{/}, $ctgs; #несколько категорий
    my @anc2;
    push @anc2, ancestors_add($_) for @ctgs;

    print join("*", @anc1), "\t", join("*", @anc2), "\t$bid1\n";
}


#--- добавление предков для категории ---
sub ancestors_add {
    my ($categ) = @_;

    my @ancestors; #все предки категории
    my $ancestor = $categ;
    while ($ancestor = $proj->categs_tree->get_minicateg_parent($ancestor)) {
        push @ancestors, $ancestor;
    }

    return join("/", reverse @ancestors)."/$categ";
}
