#!/usr/bin/perl -w
#добавление расстояния между категориями в результаты работы ctg_detect.py

use strict;
use utf8;
use open ":utf8";
use Data::Dumper;

binmode STDIN, ':utf8';
binmode STDOUT, ':utf8';
binmode STDERR, ':utf8';

#use FindBin;
#use lib "$FindBin::Bin/../lib";
use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";

use Utils::Common;
use Project;
use BM::Phrase;
use BM::PhraseList;
use Time::HiRes qw(tv_interval gettimeofday);

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


my $NEIGHBORS = 2; #число соседей сверху и снизу
my $size = 1 + 2 * $NEIGHBORS + 1 + 1; #размер окна (см. ctg_detect.py)

my @recs; #ОКНО
my $cnt = 0;
while (<STDIN>) { #bnr_ctg_corr (см. ctg_detect.py)
    chomp;

    if (++$cnt > $size ) {
        my ($dist_sem_sint1, $ctg1, $core1, $trash1, $bid1, $title1, $body1) = split /\t/, $recs[1]; #см. bnr_ctg_corr

        my $avg = ($size - 1) / 2; #индекс средней записи в окне
        my ($dist_sem_sint_avg, $ctg_avg, $core_avg, $trash_avg, $cover_avg, $bid_avg, $title_avg, $body_avg) = split /\t/, $recs[$avg]; #середина окна - "подозрительная" категория

        my ($dist_tree, $type) = dist_tree($ctg1, $ctg_avg); #расстояние между категориями НА ДЕРЕВЕ (тип связи: 0 - нейтральный, 1 - род-вид, -1 - вид-род)
        my $neigh_avg_dist = neigh_avg_dist(\@recs); #расстояние между СОСЕДНИМИ core+trash и СРЕДНИМ title+body

        #----------------------------
        for my $i (0..$size-1) {
            if ($i > 0 && $i < $size-1 && $i != $avg) {
                my ($dist_sem_sint, $ctg, $core, $trash, $bid, $title, $body) = split /\t/, $recs[$i]; #см. bnr_ctg_corr

                my $dist_avg_neigh = sem_sint_dist($core_avg, $trash_avg, $title, $body); #расстояние ОТ neigh ДО avg
                my $dist_neigh_avg = sem_sint_dist($core, $trash, $title_avg, $body_avg); #расстояние ОТ avg ДО neigh 
                print "neigh & avg:$dist_avg_neigh\t$dist_neigh_avg\n";
            }
        }
        #----------------------------

        for my $i (0..$size-1) {
            if ($i != $avg) {
                print "$recs[$i]\n";
            } else {
                print "*$dist_sem_sint_avg\t$dist_tree ($type)\t", join("\t", ($ctg_avg, $core_avg, $trash_avg, $cover_avg, $bid_avg, $title_avg, $body_avg)), "\n";
            }
        }

        @recs = ();
        $cnt = 1;
    }
    push @recs, $_;
}


#--- расстояние между категориями на дереве (длина кратчайшего пути для перехода из одной категории в другую) ---
sub dist_tree {
    my ($cat_1, $cat_2) = @_;

    my $cat_1_anc = ancestors_add($cat_1); #добавление предков для категории
    my @lev_1 = split m{/}, $cat_1_anc; #уровень категории на дереве

    my $cat_2_anc = ancestors_add($cat_2);
    my @lev_2 = split m{/}, $cat_2_anc;

    #вычисление расстояния между категориями
    my $i_min = $#lev_1 < $#lev_2 ? $#lev_1 : $#lev_2;
    my $cat_dist = 0;
    for my $i (0.. $i_min) {
        $cat_dist++ if $lev_1[$i] eq $lev_2[$i];
    }
    $cat_dist = @lev_1 + @lev_2 - 2*$cat_dist;

    my $type = 0; #тип связи:
    if ($cat_1_anc =~ m{^$cat_2_anc}) {
        $type = -1; #$cat_1_anc - вид, $cat_2_anc - род
    } elsif ($cat_2_anc =~ m{^$cat_1_anc}) {
        $type = 1; #$cat_1_anc - род, $cat_2_anc - вид
    }

    print "$cat_1_anc\t", @lev_1+0, "\n";
    print "$cat_2_anc\t", @lev_2+0, "\n";

    return ($cat_dist, $type);
}


#--- добавление предков для категории ---
sub ancestors_add {
    my ($categ) = @_;

    my @ancestors; #все предки категории
    my $ancestor = $categ;
    while ($ancestor = $proj->categs_tree->get_minicateg_parent($ancestor)) {
        push @ancestors, $ancestor;
    }

    return join("/", reverse @ancestors)."/$categ";
}


#--- расстояние между соседними core+trash и средним title+body ---
sub neigh_avg_dist {
    my ($recs) = @_;

    my $size = @{$recs} + 0; #размер окна
    my $avg = ($size - 1) / 2; #индекс средней записи в окне

    my ($dist_sem_sint_avg, $ctg_avg, $core_avg, $trash_avg, $cover_avg, $bid_avg, $title_avg, $body_avg) = split /\t/, $$recs[$avg]; #середина окна - "подозрительная" категория

    my %pos_sem; #*** словарь MIN СЕМАНТИЧЕСКИХ позиций слов в core+trash СОСЕДЕЙ
    for my $i (0..$size-1) {
        if ($i > 0 && $i < $size-1 && $i != $avg) {
            my ($dist_sem_sint, $ctg, $core, $trash, $bid, $title, $body) = split /\t/, $$recs[$i]; #см. bnr_ctg_corr

            $core =~ s/^\( //;
            $trash =~ s/ \)$//;
            my $j = 0;
            for my $wrd (split / /, $core) { #нумерация с шагом = 0.5
                my $num = ($j + 1.0) / 2;
                $pos_sem{$wrd} = $num if !$pos_sem{$wrd} || $pos_sem{$wrd} > $num;
                $j++;
            }
            for my $wrd (split / /, $trash) { #нумерация с шагом = 1
                $j++;
                $pos_sem{$wrd} = $j if !$pos_sem{$wrd} || $pos_sem{$wrd} > $j;
            }
        }
    }

    my $title_pre = $proj->phrase($title_avg)->get_banner_prefiltered_phrase->text; #префильтрация title
    my $title_nrm = $proj->phrase($title_pre)->norm_phr_ordered; #нормализация title с учетом порядка слов

    my $body_pre = $proj->phrase($body_avg)->get_banner_prefiltered_phrase->text; #префильтрация body
    my $body_nrm = $proj->phrase($body_pre)->norm_phr_ordered; #нормализация body с учетом порядка слов

    my %pos_sint; #*** словарь MIN СИНТАКСИЧЕСКИХ позиций в title+body СРЕДНЕГО баннера
    my $j = 0;
    for my $wrd (split / /, $title_nrm) { #нумерация с шагом = 0.5
        my $num = ($j + 1.0) / 2;
        $pos_sint{$wrd} = $num if !$pos_sint{$wrd} || $pos_sint{$wrd} > $num;
        $j++;
    }
    for my $wrd (split / /, $body_nrm) { #нумерация с шагом = 1
        $j++;
        $pos_sint{$wrd} = $j if !$pos_sint{$wrd} || $pos_sint{$wrd} > $j;
    }

    my $dist_neigh = 0; #РАССТОЯНИЕ между core+trash и title+body
    my $num = 0;
    for my $wrd (keys %pos_sint) {
        if ($pos_sem{$wrd}) {
            $num++;
            $dist_neigh += abs($pos_sem{$wrd} - $pos_sint{$wrd});
        }
    }
    $dist_neigh = $num > 0 ? sprintf("%.2f", $dist_neigh / $num) : 100;
    print "DIST_NEIGH=$dist_neigh\n";

    return $dist_neigh;
}


#--- расстояние между core+trash и title+body ---
sub sem_sint_dist {
    my ($core, $trash, $title, $body) = @_;

    $core =~ s/^\( //;
    $trash =~ s/ \)$//;

    #--- СЕМАНТИКА ---
    my %pos_sem; #словарь семантических позиций
    my $cnt = 0;
    for my $wrd (split / /, $core) {
        my $num = ($cnt + 1.0) / 2; #нумерация с шагом = 0.5
        $cnt++;
        $pos_sem{$wrd} = $num;
    }
    for my $wrd (split / /, $trash) {
        $cnt++;
        my $num = $cnt; #нумерация с шагом = 1
        $pos_sem{$wrd} = $num;
    }

    #--- СИНТАКСИС ---
    my $title_pre = $proj->phrase($title)->get_banner_prefiltered_phrase->text; #префильтрация title
    my $title_nrm = $proj->phrase($title_pre)->norm_phr_ordered; #нормализация title с учетом порядка слов

    my $body_pre = $proj->phrase($body)->get_banner_prefiltered_phrase->text;
    my $body_nrm = $proj->phrase($body_pre)->norm_phr_ordered;

    my %pos_sint; #словарь синтаксических позиций
    $cnt = 0;
    for my $wrd (split / /, $title_nrm) {
        if ($pos_sem{$wrd} && !$pos_sint{$wrd}) { #в %pos_sint д.б. только слова, которые есть в %pos_sem
            my $num = ($cnt + 1.0) / 2; #нумерация с шагом = 0.5
            $cnt++;
            $pos_sint{$wrd} = $num;
        }
    }
    for my $wrd (split / /, $body_nrm) {
        if ($pos_sem{$wrd} && !$pos_sint{$wrd}) { #в %pos_sint д.б. только слова, которые есть в %pos_sem
            $cnt++;
            my $num = $cnt; #нумерация с шагом = 1
            $pos_sint{$wrd} = $num;
        }
    }

    #--- РАССТОЯНИЕ ---
    my $dist = 0; #расстояние между core+trash и title+body
    for my $wrd (keys %pos_sint) {
        $dist += abs($pos_sem{$wrd} - $pos_sint{$wrd});
    }
    $cnt = scalar(keys %pos_sint);
    $dist = $cnt > 0 ? sprintf("%.2f", $dist / $cnt) : 100;

    return $dist;
}
