#!/usr/bin/perl -w
#категоризация с помощью словаря микроядер

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");


open F, "TrainExact_core_2"; #микроядра (ctgs_rank_core.pl, ctgs_rank_core_2.pl)
chomp (my @cores = <F>); #my ($core, $size, $trash, $ctg) = split /\t/;

open F, "Test_norm";
while (<F>) { #Test_norm
    chomp;
    my ($bnorm, $tnorm, $bid) = split /\t/;

    my %dup;
    my @uniq = grep { !$dup{$_}++ } split / /, "$tnorm $bnorm"; #удаление дублей из нормализованного текста

    my @good = @uniq; #из-за потенциальной очистки (например, от цифр и т.п.)
    for my $i (0..$#good-1) { #генерация пар слов для поиска семантического ядра (*здесь и нужны слова @good*)
        for my $j ($i+1..$#good) {
            my $pair1 = "$good[$i] $good[$j]";
            my ($ind1, $ind2) = core_search($pair1, \@cores); #индексы ближайших соседей

            my ($cover, $size, $ctg, $core) = core_inf(\@uniq, $pair1, \@cores, $ind1); #выделение информации из ядер
            print "$bid\t$cover\t$size\t$ctg\t$core\n" if $cover > 0; # 0 - ядро не найдено или неинформативное

            ($cover, $size, $ctg, $core) = core_inf(\@uniq, $pair1, \@cores, $ind2); #выделение информации из ядер
            print "$bid\t$cover\t$size\t$ctg\t$core\n" if $cover > 0; # 0 - ядро не найдено или неинформативное

            my $pair2 = "$good[$j] $good[$i]";
            ($ind1, $ind2) = core_search($pair2, \@cores); #индексы ближайших соседей

            ($cover, $size, $ctg, $core) = core_inf(\@uniq, $pair2, \@cores, $ind1); #выделение информации из ядер
            print "$bid\t$cover\t$size\t$ctg\t$core\n" if $cover > 0; # 0 - ядро не найдено или неинформативное

            ($cover, $size, $ctg, $core) = core_inf(\@uniq, $pair2, \@cores, $ind2); #выделение информации из ядер
            print "$bid\t$cover\t$size\t$ctg\t$core\n" if $cover > 0; # 0 - ядро не найдено или неинформативное
       }
    }
}


#--- бинарный поиск ядер ---
sub core_search {
    my ($pair, $cores) = @_;
    
    my $first = 0;
    my $last = $#{$cores};
    while ($first <= $last) {
        my $mid = $first + int(($last - $first) / 2);
        if ($pair lt $$cores[$mid]) {
            $last = $mid - 1;
        } elsif ($pair gt $$cores[$mid]) {
            $first = $mid + 1;
        } else { #совпадение
            $last = $mid - 1;
            $first = $mid + 1;
            last;
        }
    }
    
    $last = 0 if $last < 0;
    $first = $#{$cores} if $first > $#{$cores};

    return ($last, $first);
}


#--- выделение информации из ядер ---
sub core_inf {
    my ($uniq, $pair, $cores, $ind) = @_;

    my ($core, $size, $trash, $ctg) = split /\t/, $$cores[$ind];
    my $cover = 2; #длина ядра
    if ($pair eq $core) {
        my @trash = split / /, $trash;
        my %trash;
        $trash{$_} = 1 for @trash;

        for (@$uniq) {
            $cover++ if $trash{$_};
        }

        unless ($core =~ /^(доставка бесплатный|подарок доставка|со скидка|наличие доставка|наличие заказывать|заказывать доставка|гарантия доставка|доставка рф|доставка цена|гарантия год|скидка купить|купить успевать|оптовый доставка|купить цена|доставка дом|наличие заказ|1100 м|кредит 000|000 выгода|кредит 5|light доставка|ключ под|ремонт дом|россия отправка|запчасть доставка|диагностика замена|ремонт обслуживание|запчасть наличие)$/) {
            return ($cover, $size, $ctg, $core);
        } else {
            return (0, 0, "", "");
        }
    } else {
        return (0, 0, "", "");
    }
}
