#!/usr/bin/perl -w
#расстояние между категориями

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");

use lib "/home/yuryz/arcadia/rt-research/broadmatching/scripts/lib";
use Project;

my $proj = Project->new({ 
    load_dicts => 1,
    load_minicategs_light => 1,
});


print ctgs_sim($ARGV[0], $ARGV[1]), "\n";

#--- вычисление сходства между мультимножествами автокатегории и категорией ядра ---
sub ctgs_sim {
    my ($AutoCategoryNames, $CoreCategoryNames) = @_;

    my $AutoMS = mset($AutoCategoryNames); #мультимножество автокатегории
    my ($countI, @pairsI) = split /\t/, $AutoMS;
    my %dicI; #мультимножество (частотный словарь)
    for (my $i2 = 0; $i2 <= $#pairsI-1; $i2 += 2) { #
        $dicI{$pairsI[$i2]} = $pairsI[$i2+1]
    }

    my $CoreMS = mset($CoreCategoryNames); #мультимножество категории ядра
    my ($countJ, @pairsJ) = split /\t/, $CoreMS;
    my $cross = 0; #пересечение множеств
    for (my $j2 = 0; $j2 <= $#pairsJ-1; $j2 += 2) { #
        if ($dicI{$pairsJ[$j2]}) {
            $cross += $dicI{$pairsJ[$j2]} <= $pairsJ[$j2+1] ? $dicI{$pairsJ[$j2]} : $pairsJ[$j2+1]; #min частота
        }
    }

    my $sim = sprintf("%.3f", 2.0 * $cross / ($countI + $countJ));

    return $sim;
}


#--- вычисление мультимножества ---
sub mset {
    my ($mctgs) = @_;

    my @ctgs = split m{/}, $mctgs;
    my $cnt = 0; #количество элементов мультимножества
    my %dic = (); #частотный словарь категорий (мультимножество)

    for my $ctgs (@ctgs) {
        my $anc = ancestors_add($ctgs); #предки категории
        my @anc = split m{/}, $anc;
        for (@anc) {
            $cnt++;
            $dic{$_}++;
        }
    }

    my @pairs = ();
    for (sort keys %dic) {
        push @pairs, "$_\t$dic{$_}"; #пары <категория, частота>
    }

    return "$cnt\t".join("\t", @pairs); #мультимножество
}


#--- добавление предков для категории ---
sub ancestors_add {
    my ($categ) = @_;

    my @ancestors; #все предки категории
    my $ancestor = $categ;
    while ($ancestor = $proj->categs_tree->get_minicateg_parent($ancestor)) {
        push @ancestors, $ancestor;
    }

    return join("/", reverse @ancestors)."/$categ";
}


#--- проверка, что вторая категория является предком первой ---
sub is_ancestor {
    my ($ctg1, $ctg2) = @_;

    my %ctg2;
    my @ctg2 = split m{/}, $ctg2;
    $ctg2{$_} = 1 for @ctg2;

    my @ctg1 = split m{/}, $ctg1;
    return 0 if @ctg1 > 1;
    my $anc = $proj->categs_tree->get_minicateg_parent($ctg1); #предок
    return $anc && $ctg2{$anc} ? 1 : 0;
}
