#!/usr/bin/perl -w
#печать пар семантически наиболее близких категорий, расположенных наиболее далеко на дереве Каталогии

use strict;
use utf8;
use open ':utf8';
no warnings 'utf8';
use Data::Dumper;

binmode(STDIN,  ":utf8");
binmode(STDOUT, ":utf8");
binmode(STDERR, ":utf8");


my %ctgs;
open F, "clust_with_num";
while (<F>) {
    chomp;
    my ($ctg, $clust) = split /\t/;
    push @{$ctgs{"C$clust"}}, $ctg;
}

clust_pr($ARGV[0], 0); #perl ctgs_tree.pl "C19147" >ztree_full.txt


#--- печать  кластера ---
sub clust_pr {
    my ($clust, $lev) = @_;
    print " " x $lev, "$clust\n";
    for my $ctg (sort @{$ctgs{$clust}}) {
        if ($ctg =~ /^C[0-9]/) {
            clust_pr($ctg, $lev+1);
        } else {
            print " " x ($lev+1), "$ctg\n";
        }
    }
}
