#!/usr/bin/python
# -*- coding: utf-8 -*-

#конвертирование //home/catalogia/contest/TrainExact и //home/catalogia/contest/Test в формат для поиска семантических ядер

import sys
import re
import yt.wrapper as yt


def conv_exact(rec):
    bnorm = rec['NormTitle'] + ' ' + rec['NormBody']

    L = bnorm.split()
    wrds = set(L) #удаляем дубли
    L = []
    for wrd in wrds:
        wrd = re.sub('^[!+$]+', '', wrd)
        #через без для под про со с
        if len(unicode(wrd, 'utf-8')) <= 1 or re.findall('^([0-9.]+|самовывоз|сегодня|всегда|каждый|минута|нечего|оплата|сейчас|более|здесь|любой|много|стать|также|есть|жать|ваш|где|мес|мин|раз|руб|тут|тыс|час|др|кв|кг|км|м2|мм|пр|см|ул)$', wrd) or re.findall('^_', wrd) or wrd == 'moderatebadwordtype':
            continue
        L.append(wrd)
    L.sort()

    for i in range(len(L)-1):
        for j in range(i+1, len(L)):
            yield { "two_word_index": L[i] + ' ' + L[j], "uniq_clean": ' '.join(L), "bid": rec['BannerID'], "title": rec['Title'], "body": rec['Body'], "mctgs_tag": rec['CategoryNames'], "domain": rec['Domain'], "mctgs": rec['AutoCategoryNames'], "title_norm": rec['NormTitle'], "body_norm": rec['NormBody'], "title_extension_norm": rec['NormTitleExtension'], "phrases_norm": rec['Phrases'] }
            yield { "two_word_index": L[j] + ' ' + L[i], "uniq_clean": ' '.join(L), "bid": rec['BannerID'], "title": rec['Title'], "body": rec['Body'], "mctgs_tag": rec['CategoryNames'], "domain": rec['Domain'], "mctgs": rec['AutoCategoryNames'], "title_norm": rec['NormTitle'], "body_norm": rec['NormBody'], "title_extension_norm": rec['NormTitleExtension'], "phrases_norm": rec['Phrases'] }
        #учет однословных ядер
        yield { "two_word_index": L[i], "uniq_clean": ' '.join(L), "bid": rec['BannerID'], "title": rec['Title'], "body": rec['Body'], "mctgs_tag": rec['CategoryNames'], "domain": rec['Domain'], "mctgs": rec['AutoCategoryNames'], "title_norm": rec['NormTitle'], "body_norm": rec['NormBody'], "title_extension_norm": rec['NormTitleExtension'], "phrases_norm": rec['Phrases'] }
    if len(L) > 0: #учет однословных ядер (последнее слово)
        yield { "two_word_index": L[-1], "uniq_clean": ' '.join(L), "bid": rec['BannerID'], "title": rec['Title'], "body": rec['Body'], "mctgs_tag": rec['CategoryNames'], "domain": rec['Domain'], "mctgs": rec['AutoCategoryNames'], "title_norm": rec['NormTitle'], "body_norm": rec['NormBody'], "title_extension_norm": rec['NormTitleExtension'], "phrases_norm": rec['Phrases'] }


def conv_test(rec):
    bnorm = rec['NormTitle'] + ' ' + rec['NormBody']

    L = bnorm.split()
    wrds = set(L) #удаляем дубли
    L = []
    for wrd in wrds:
        wrd = re.sub('^[!+$]+', '', wrd)
        #через без для под про со с
        if len(unicode(wrd, 'utf-8')) <= 1 or re.findall('^([0-9.]+|самовывоз|сегодня|всегда|каждый|минута|нечего|оплата|сейчас|более|здесь|любой|много|стать|также|есть|жать|ваш|где|мес|мин|раз|руб|тут|тыс|час|др|кв|кг|км|м2|мм|пр|см|ул)$', wrd) or re.findall('^_', wrd) or wrd == 'moderatebadwordtype':
            continue
        L.append(wrd)
    L.sort()

    for i in range(len(L)-1):
        for j in range(i+1, len(L)):
            yield { "two_word_index": L[i] + ' ' + L[j], "uniq_clean": ' '.join(L), "bid": rec['BannerID'], "title": rec['Title'], "body": rec['Body'], "mctgs_tag": rec['AutoCategoryNames'], "domain": rec['Domain'], "mctgs": rec['AutoCategoryNames'], "title_norm": rec['NormTitle'], "body_norm": rec['NormBody'], "title_extension_norm": rec['NormTitleExtension'], "phrases_norm": rec['Phrases'] }
            yield { "two_word_index": L[j] + ' ' + L[i], "uniq_clean": ' '.join(L), "bid": rec['BannerID'], "title": rec['Title'], "body": rec['Body'], "mctgs_tag": rec['AutoCategoryNames'], "domain": rec['Domain'], "mctgs": rec['AutoCategoryNames'], "title_norm": rec['NormTitle'], "body_norm": rec['NormBody'], "title_extension_norm": rec['NormTitleExtension'], "phrases_norm": rec['Phrases'] }
        #учет однословных ядер
        yield { "two_word_index": L[i], "uniq_clean": ' '.join(L), "bid": rec['BannerID'], "title": rec['Title'], "body": rec['Body'], "mctgs_tag": rec['AutoCategoryNames'], "domain": rec['Domain'], "mctgs": rec['AutoCategoryNames'], "title_norm": rec['NormTitle'], "body_norm": rec['NormBody'], "title_extension_norm": rec['NormTitleExtension'], "phrases_norm": rec['Phrases'] }
    if len(L) > 0: #учет однословных ядер (последнее слово)
        yield { "two_word_index": L[-1], "uniq_clean": ' '.join(L), "bid": rec['BannerID'], "title": rec['Title'], "body": rec['Body'], "mctgs_tag": rec['AutoCategoryNames'], "domain": rec['Domain'], "mctgs": rec['AutoCategoryNames'], "title_norm": rec['NormTitle'], "body_norm": rec['NormBody'], "title_extension_norm": rec['NormTitleExtension'], "phrases_norm": rec['Phrases'] }


def main():
    tab1 = '//home/catalogia/contest/TrainExact'
    tab2 = '//tmp/yuryz/exact4process'

    yt.run_map(conv_exact, tab1, tab2)
    yt.run_sort(tab2, sort_by=['two_word_index', 'bid', 'uniq_clean'])

    tab3 = '//home/catalogia/contest/Test'
    tab4 = '//tmp/yuryz/test4process'

    yt.run_map(conv_test, tab3, tab4)
    yt.run_sort(tab4, sort_by=['two_word_index', 'bid', 'uniq_clean'])


if __name__ == '__main__':
    main()
